/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.ryusoken;

import java.util.UUID;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveStatBonusAbility;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;

public class RyusokenBonusesAbility
extends PassiveStatBonusAbility {
    private static final UUID RYUSOKEN_ATTACK_BONUS_UUID = UUID.fromString("4e0e1f28-8798-4d86-bdc3-da7b250f787d");
    private static final AttributeModifier RYUSOKEN_ATTACK_SPEED_MODIFIER;
    private static final Predicate<LivingEntity> RYUSOKEN_CHECK;
    private static final AbilityDescriptionLine.IDescriptionLine<RyusokenBonusesAbility> TOOLTIP;
    public static final AbilityCore<RyusokenBonusesAbility> INSTANCE;

    public RyusokenBonusesAbility(AbilityCore<RyusokenBonusesAbility> core) {
        super(core);
        this.pushDynamicAttribute((Attribute)ModAttributes.PUNCH_DAMAGE.get(), entity -> this.getModifier((LivingEntity)entity));
        this.pushStaticAttribute(Attributes.field_233825_h_, RYUSOKEN_ATTACK_SPEED_MODIFIER);
    }

    private AttributeModifier getModifier(LivingEntity entity) {
        double bonus = this.getBonus(entity);
        return new AttributeModifier(RYUSOKEN_ATTACK_BONUS_UUID, "Ryusoken Attack Bonus", bonus, AttributeModifier.Operation.ADDITION);
    }

    private double getBonus(LivingEntity entity) {
        return 1.0 + EntityStatsCapability.get((LivingEntity)entity).getDoriki() * 3.0E-4;
    }

    private static boolean canUnlock(LivingEntity entity) {
        return EntityStatsCapability.get((LivingEntity)entity).getFightingStyle().equals((Object)CartValues.RYUSOKEN);
    }

    public Predicate<LivingEntity> getCheck() {
        return RYUSOKEN_CHECK;
    }

    static {
        RYUSOKEN_CHECK = entity -> {
            ItemStack heldItem = entity.func_184614_ca();
            return heldItem.func_190926_b();
        };
        RYUSOKEN_ATTACK_SPEED_MODIFIER = new AttributeModifier(UUID.fromString("3f670d1d-4aab-46c9-ad2c-982c7b6d375a"), "Ryusoken Attack Speed Multiplier", 0.2, AttributeModifier.Operation.ADDITION);
        TOOLTIP = (entity, ability) -> {
            ITextComponent speedStatText;
            ITextComponent punchStatText;
            ITextComponent[] lines = new ITextComponent[3];
            lines[0] = new StringTextComponent("\u00a7a" + ModI18n.ABILITY_DESCRIPTION_STAT_NAME_STATS.getString() + "\u00a7r");
            TranslationTextComponent attrName = new TranslationTextComponent(((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_233754_c_());
            float value = (float)ability.getBonus(entity);
            lines[1] = punchStatText = new AbilityStat.Builder((ITextComponent)attrName, value).withSign("+").build().getStatDescription(2);
            attrName = new TranslationTextComponent(Attributes.field_233825_h_.func_233754_c_());
            value = (float)RYUSOKEN_ATTACK_SPEED_MODIFIER.func_111164_d();
            lines[2] = speedStatText = new AbilityStat.Builder((ITextComponent)attrName, value).withSign("+").build().getStatDescription(2);
            StringBuilder sb = new StringBuilder();
            int lineId = 0;
            ITextComponent[] var10 = lines;
            int var11 = lines.length;
            for (int var12 = 0; var12 < var11; ++var12) {
                ITextComponent text = var10[var12];
                boolean hasFollowingLine = lineId++ < lines.length - 1;
                sb.append(text.getString() + (hasFollowingLine ? "\n" : ""));
            }
            return new StringTextComponent(sb.toString());
        };
        INSTANCE = new AbilityCore.Builder("Ryusoken Passive Bonuses", AbilityCategory.STYLE, AbilityType.PASSIVE, RyusokenBonusesAbility::new).setIcon(ModResources.PERK_ICON).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{TOOLTIP}).setUnlockCheck(RyusokenBonusesAbility::canUnlock).build();
    }
}

