/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.ryusoken;

import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class RyuNoKagizumeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"ryu_no_kagizume", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user grabs an opponent and deals crushing damage over time.", null)});
    private static final int COOLDOWN = 300;
    private static final int CHARGE_TIME = 40;
    private static final int PULL_TIME = 200;
    private static final float DAMAGE = 15.0f;
    private final Interval damageInterval = new Interval(20);
    public static final AbilityCore<RyuNoKagizumeAbility> INSTANCE = new AbilityCore.Builder("Ryu No Kagizume", AbilityCategory.STYLE, RyuNoKagizumeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)15.0f, (float)40.0f), ChargeComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)200.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).setUnlockCheck(RyuNoKagizumeAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addEndEvent(this::onContinuityEnd);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(100, this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final GrabEntityComponent grabComponent = new GrabEntityComponent((IAbility)this, true, true, true, 2.0f).addPullStartEvent(this::onPullStart).addPullEndEvent(this::onPullEnd);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addOnHitEvent(this::onHitEvent);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[]{CartAbilityPools.RYUSOKEN});

    public RyuNoKagizumeAbility(AbilityCore<RyuNoKagizumeAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.dealDamageComponent, this.chargeComponent, this.animationComponent, this.continuousComponent, this.grabComponent, this.hitTriggerComponent, this.poolComponent});
        super.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            if (this.continuousComponent.isContinuous()) {
                this.grabComponent.release(entity);
                this.continuousComponent.stopContinuity(entity);
            } else if (this.grabComponent.getState() == GrabEntityComponent.GrabState.IDLE && this.grabComponent.grabNearest(entity, 4.5f, 2.0f, false)) {
                this.grabComponent.triggerPulling(entity);
            } else {
                this.cooldownComponent.startCooldown(entity, 15.0f);
            }
        }
    }

    private boolean onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous() && !this.grabComponent.hasGrabbedEntity()) {
            if (this.grabComponent.grabManually(entity, target)) {
                this.grabComponent.startPulling(entity);
            }
            target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 1));
            return false;
        }
        return true;
    }

    public void onPullStart(LivingEntity entity, IAbility ability) {
        this.continuousComponent.setThresholdTime(entity, 200.0f);
    }

    public void onPullEnd(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        if (this.grabComponent.canContinueGrab(entity)) {
            this.chargeComponent.startCharging(entity, 60.0f);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (this.grabComponent.getState() != GrabEntityComponent.GrabState.GRABBED) {
                this.grabComponent.release(entity);
            }
            if (!this.grabComponent.canContinueGrab(entity)) {
                this.cooldownComponent.startCooldown(entity, 200.0f);
            }
        }
    }

    public void onChargeStart(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM);
    }

    public void onChargeTick(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.NO_HANDS.get(), 5, 0));
        if (!entity.field_70170_p.field_72995_K) {
            if (!super.canUse(entity).isFail() && this.grabComponent.canContinueGrab(entity)) {
                LivingEntity target = this.grabComponent.getGrabbedEntity();
                if (this.damageInterval.canTick()) {
                    this.dealDamageComponent.hurtTarget(entity, target, 5.0f);
                }
            } else {
                this.chargeComponent.stopCharging(entity);
            }
            entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 5, 3, false, false));
        }
    }

    public void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (this.grabComponent.hasGrabbedEntity()) {
            LivingEntity target = this.grabComponent.getGrabbedEntity();
            if (this.dealDamageComponent.hurtTarget(entity, target, 20.0f)) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.FRAGILE.get(), 40, 0, false, false));
            }
            this.grabComponent.release(entity);
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.RYUSOKEN) && questProps.hasFinishedQuest(CartQuests.RYUSOKEN_TRIAL_02);
    }
}

