/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.ryusoken;

import java.util.List;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.MrMagicalCart.cartaddon.particles.effects.ryusoken.IbukiGroundRangeEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class RyuNoIbukiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"ryu_no_ibuki", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user pierces the ground, with each second of charge increasing damage and range.", null)});
    private static final float DAMAGE = 15.0f;
    private static final float RANGE = 3.0f;
    private static final float COOLDOWN = 200.0f;
    private static IbukiGroundRangeEffect PARTICLES = new IbukiGroundRangeEffect();
    public static final AbilityCore<RyuNoIbukiAbility> INSTANCE = new AbilityCore.Builder("Ryu No Ibuki", AbilityCategory.STYLE, RyuNoIbukiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)15.0f, (float)27.0f), RangeComponent.getTooltip((float)3.0f, (float)15.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE), CooldownComponent.getTooltip((float)160.0f)}).setSourceType(new SourceType[]{SourceType.FIST, SourceType.INDIRECT}).setSourceElement(SourceElement.SHOCKWAVE).setSourceHakiNature(SourceHakiNature.HARDENING).setUnlockCheck(RyuNoIbukiAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::tickChargeEvent).addEndEvent(this::endChargeEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private float range = 3.0f;
    private float damage = 15.0f;
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.RYUSOKEN, new AbilityPool2[0]);

    public RyuNoIbukiAbility(AbilityCore<RyuNoIbukiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.animationComponent, this.poolComponent, this.chargeComponent, this.continuousComponent, this.dealDamageComponent, this.rangeComponent});
        this.addCanUseCheck(AbilityHelper::requiresOnGround);
        this.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            this.animationComponent.start(entity, ModAnimations.RYU_NO_IBUKI);
            this.chargeComponent.startCharging(entity, 60.0f);
        } else {
            this.chargeComponent.stopCharging(entity);
        }
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.range = 3.0f;
        this.damage = 15.0f;
    }

    private void tickChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.getChargeTime() % 10.0f == 0.0f) {
            this.range += 1.0f;
            this.damage += 1.0f;
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 0, false, false));
        entity.func_195064_c(new EffectInstance(Effects.field_76429_m, 5, 1, false, false));
        List targets = this.rangeComponent.getTargetsInArea(entity, this.range);
        targets.stream().filter(target -> target != null && target.func_70089_S() && target.field_70170_p.func_217299_a(new RayTraceContext(target.func_213303_ch(), target.func_213303_ch().func_72441_c(0.0, -10.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)target)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK)).forEach(target -> {
            if (target.func_233570_aj_()) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 10, 0, false, false));
                target.func_195064_c(new EffectInstance(Effects.field_76421_d, 10, 2, false, false));
            }
        });
        if (this.chargeComponent.getChargeTime() == 1.0f) {
            PARTICLES.spawn((Entity)entity, entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 80.0, -90.0f, 0.0f);
        }
        if (this.chargeComponent.getChargeTime() == 20.0f) {
            PARTICLES.spawn((Entity)entity, entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 110.0, -90.0f, 0.0f);
        }
        if (this.chargeComponent.getChargeTime() == 40.0f) {
            PARTICLES.spawn((Entity)entity, entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 150.0, -90.0f, 0.0f);
        }
        if (this.chargeComponent.getChargeTime() == 60.0f) {
            PARTICLES.spawn((Entity)entity, entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 190.0, -90.0f, 0.0f);
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        List targets = this.rangeComponent.getTargetsInArea(entity, this.range);
        ModDamageSource source = ModDamageSource.causeAbilityDamage((LivingEntity)entity, (IAbility)this).setUnavoidable().bypassLogia().setPiercing(0.25f);
        targets.stream().filter(target -> target != null && target.func_70089_S() && target.field_70170_p.func_217299_a(new RayTraceContext(target.func_213303_ch(), target.func_213303_ch().func_72441_c(0.0, -10.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)target)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK)).forEach(target -> {
            if (this.dealDamageComponent.hurtTarget(entity, target, this.damage, (DamageSource)source) && target.func_233570_aj_()) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 20 + (int)this.chargeComponent.getChargeTime(), 0, false, false));
                AbilityHelper.setDeltaMovement((Entity)target, (Vector3d)entity.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b().func_186678_a(1.5));
            }
        });
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GURA_SFX.get(), SoundCategory.PLAYERS, 5.0f, 0.6f);
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.RYUSOKEN) && questProps.hasFinishedQuest(CartQuests.RYUSOKEN_TRIAL_05);
    }
}

