/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.ryusoken;

import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PreciseTalonStrikesAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"precise_talon_strikes", (Pair[])new Pair[]{ImmutablePair.of((Object)"Each consecutive hit increases the damage of the next talon strike.", null)});
    private static final int MAX_STACKS = 4;
    private static final int COOLDOWN = 200;
    public static final AbilityCore<PreciseTalonStrikesAbility> INSTANCE = new AbilityCore.Builder("Precise Talon Strikes", AbilityCategory.STYLE, PreciseTalonStrikesAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)10.0f, (float)25.0f), CooldownComponent.getTooltip((float)200.0f), StackComponent.getTooltip((int)4)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).setUnlockCheck(PreciseTalonStrikesAbility::canUnlock).build();
    private final StackComponent stackComponent = new StackComponent((IAbility)this, 4);

    public PreciseTalonStrikesAbility(AbilityCore<PreciseTalonStrikesAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.stackComponent});
        this.continuousComponent.addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
        super.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && this.stackComponent.getStacks() == 0) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.stackComponent.revertStacksToDefault(entity, (IAbility)this);
    }

    public float getPunchDamage() {
        if (this.stackComponent.getStacks() == 3) {
            return 15.0f;
        }
        if (this.stackComponent.getStacks() == 2) {
            return 20.0f;
        }
        if (this.stackComponent.getStacks() == 1) {
            return 25.0f;
        }
        return 10.0f;
    }

    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        if (this.continuousComponent.isContinuous()) {
            target.func_195064_c(new EffectInstance((Effect)ModEffects.FRAGILE.get(), 40, 0, false, false));
            if (entity.func_70681_au().nextInt(10) < 2) {
                AbilityHelper.disableAbilities((LivingEntity)target, (int)100, abl -> abl.hasComponent(ModAbilityKeys.POOL) && ((PoolComponent)abl.getComponent(ModAbilityKeys.POOL).get()).containsPool(ModAbilityPools.TEKKAI_LIKE));
            }
            if (this.stackComponent.getStacks() > 0) {
                this.stackComponent.addStacks(entity, (IAbility)this, -1);
            }
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.TALON_STRIKE.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)target.func_226280_cw_(), (double)target.func_226281_cx_());
        }
        return true;
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    public int getUseLimit() {
        return -1;
    }

    public float getPunchCooldown() {
        return 200.0f;
    }

    public boolean isParallel() {
        return true;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.RYUSOKEN) && questProps.hasFinishedQuest(CartQuests.RYUSOKEN_TRIAL_01);
    }
}

