/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.ryusoken;

import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.ModifiedHumanHelper;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.entities.projectiles.ryusoken.DragonsWrathProjectile;
import net.MrMagicalCart.cartaddon.init.CartAnimations;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;

public class DragonsWrathAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"dragons_wrath", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user charges and shoots a giant ball of compressed air at their opponents. (Fruitless)", null)});
    private static final float COOLDOWN = 800.0f;
    public static final AbilityCore<DragonsWrathAbility> INSTANCE = new AbilityCore.Builder("Dragons Wrath", AbilityCategory.STYLE, DragonsWrathAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChargeComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)800.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceElement(SourceElement.AIR).setUnlockCheck(DragonsWrathAbility::canUnlock).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(100, this::startChargingEvent).addTickEvent(100, this::tickChargingEvent).addEndEvent(100, this::endChargingEvent);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);

    public DragonsWrathAbility(AbilityCore<DragonsWrathAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.animationComponent, this.projectileComponent, this.chargeComponent});
        this.addCanUseCheck(AbilityLimits::fruitless);
        this.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        super.addCanUseCheck(ModifiedHumanHelper::checkModifiedHuamn);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            this.chargeComponent.startCharging(entity, 60.0f);
        }
    }

    private void startChargingEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, CartAnimations.DRAGONS_WRATH);
    }

    private void tickChargingEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 2, 2, false, false));
    }

    private void endChargingEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.projectileComponent.shoot(entity, 3.0f, 0.5f);
        this.cooldownComponent.startCooldown(entity, 800.0f);
    }

    private DragonsWrathProjectile createProjectile(LivingEntity entity) {
        DragonsWrathProjectile proj = new DragonsWrathProjectile(entity.field_70170_p, entity, this);
        return proj;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.RYUSOKEN) && questProps.hasFinishedQuest(CartQuests.RYUSOKEN_TRIAL_08);
    }
}

