/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.ryusoken;

import java.util.UUID;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.ModifiedHumanHelper;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class DragonsLawnMowerAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"dragons_lawnmower", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user grabs their target and drags them across the ground. (Fruitless)", null)});
    private static final int COOLDOWN = 600;
    private static final int HOLD_TIME = 80;
    private static final float RANGE = 2.0f;
    public static final AbilityCore<DragonsLawnMowerAbility> INSTANCE = new AbilityCore.Builder("Dragons Lawnmower", AbilityCategory.STYLE, DragonsLawnMowerAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)6.0f), ContinuousComponent.getTooltip((float)80.0f), CooldownComponent.getTooltip((float)600.0f), RangeComponent.getTooltip((float)2.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).setSourceHakiNature(SourceHakiNature.HARDENING).setUnlockCheck(DragonsLawnMowerAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final GrabEntityComponent grabEntityComponent;
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[]{CartAbilityPools.RYUSOKEN});
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent((IAbility)this);
    private static final AbilityAttributeModifier STEP_ASSIST_MODIFIER = new AbilityAttributeModifier(UUID.fromString("226d6d0c-3cae-421d-bfa5-4b3cf850b627"), INSTANCE, "Dragons Lawnmower Step Assist Modifier", 2.0, AttributeModifier.Operation.ADDITION);

    public DragonsLawnMowerAbility(AbilityCore<DragonsLawnMowerAbility> core) {
        super(core);
        this.grabEntityComponent = new GrabEntityComponent((IAbility)this, false, true, 2.0f);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.changeStatsComponent, this.poolComponent, this.dealDamageComponent, this.continuousComponent, this.rangeComponent, this.grabEntityComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_ASSIST_MODIFIER);
        super.addCanUseCheck(AbilityLimits::fruitless);
        super.addCanUseCheck(ModifiedHumanHelper::checkModifiedHuamn);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 80.0f);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.changeStatsComponent.applyModifiers(entity);
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            LivingEntity grabbedTarget = this.grabEntityComponent.getGrabbedEntity();
            if (!super.canUse(entity).isFail() && (grabbedTarget == null || this.grabEntityComponent.canContinueGrab(entity))) {
                if (grabbedTarget == null) {
                    this.grabEntityComponent.grabNearest(entity, 2.0f, 1.4f, false);
                }
                if (this.continuousComponent.getContinueTime() % 15.0f == 0.0f) {
                    this.dealDamageComponent.hurtTarget(entity, grabbedTarget, 2.0f);
                    grabbedTarget.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 20, 0, false, false));
                }
            } else {
                this.continuousComponent.stopContinuity(entity);
            }
        }
        Vector3d look = entity.func_70040_Z();
        Vector3d speed = look.func_216372_d(1.25, 0.0, 1.25);
        entity.func_213315_a(MoverType.SELF, speed);
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.changeStatsComponent.removeModifiers(entity);
            this.grabEntityComponent.release(entity);
            this.cooldownComponent.startCooldown(entity, 600.0f);
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.RYUSOKEN) && questProps.hasFinishedQuest(CartQuests.RYUSOKEN_TRIAL_07);
    }
}

