/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.ryupteranodonextra;

import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.ryupteranodon.TempuraudonProjectile;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class ReworkedTempuraudonAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"tempuraudon", (Pair[])new Pair[]{ImmutablePair.of((Object)"Stretches its head back, releasing it really fast and acting as a sniper.", null)});
    private static final int COOLDOWN = 240;
    private static final int CHARGE_TIME = 60;
    public static final AbilityCore<ReworkedTempuraudonAbility> INSTANCE = new AbilityCore.Builder("Tempuraudon", AbilityCategory.DEVIL_FRUITS, ReworkedTempuraudonAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)240.0f), ChargeComponent.getTooltip((float)60.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addEndEvent(this::onChargeEnd);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final RequireMorphComponent requireMorphComponent;
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.DASH, new AbilityPool2[0]);

    public ReworkedTempuraudonAbility(AbilityCore<ReworkedTempuraudonAbility> core) {
        super(core);
        this.requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.PTERA_ASSAULT.get(), new MorphInfo[]{(MorphInfo)ModMorphs.PTERA_FLY.get()});
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.poolComponent, this.chargeComponent, this.projectileComponent, this.requireMorphComponent});
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 60.0f);
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 5.0f, 0.0f);
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DASH_ABILITY_SWOOSH_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private TempuraudonProjectile createProjectile(LivingEntity entity) {
        TempuraudonProjectile proj = new TempuraudonProjectile(entity.field_70170_p, entity, (Ability)this);
        return proj;
    }
}

