/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.riki;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;

public class RikiSlamAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"riki_slam", (Pair[])new Pair[]{ImmutablePair.of((Object)"Grabs an opponent, lifts them up, and slams them into the ground.", null)});
    private static final int PULL_TIME = 200;
    private static final int CHARGE_TIME = 20;
    private static final float COOLDOWN = 180.0f;
    private static final float DAMAGE = 20.0f;
    public static final AbilityCore<RikiSlamAbility> INSTANCE = new AbilityCore.Builder("Riki Slam", AbilityCategory.DEVIL_FRUITS, RikiSlamAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)180.0f), ChargeComponent.getTooltip((float)20.0f), DealDamageComponent.getTooltip((float)30.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addEndEvent(this::onContinuityEnd);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final GrabEntityComponent grabComponent = new GrabEntityComponent((IAbility)this, true, false, true, 2.0f).addPullStartEvent(this::onPullStart).addPullEndEvent(this::onPullEnd);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addOnHitEvent(this::onHitEvent);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);

    public RikiSlamAbility(AbilityCore<RikiSlamAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.dealDamageComponent, this.chargeComponent, this.animationComponent, this.grabComponent, this.hitTriggerComponent, this.poolComponent});
        this.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            if (this.continuousComponent.isContinuous()) {
                this.grabComponent.release(entity);
                this.continuousComponent.stopContinuity(entity);
            } else if (this.grabComponent.getState() == GrabEntityComponent.GrabState.IDLE && this.grabComponent.grabNearest(entity, 4.5f, 2.0f, false)) {
                this.grabComponent.triggerPulling(entity);
            } else {
                this.cooldownComponent.startCooldown(entity, 15.0f);
            }
        }
    }

    private boolean onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous() && !this.grabComponent.hasGrabbedEntity()) {
            if (this.grabComponent.grabManually(entity, target)) {
                this.grabComponent.startPulling(entity);
            }
            target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 1));
            return false;
        }
        return true;
    }

    public void onPullStart(LivingEntity entity, IAbility ability) {
        this.continuousComponent.setThresholdTime(entity, 200.0f);
    }

    public void onPullEnd(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        if (this.grabComponent.canContinueGrab(entity)) {
            this.chargeComponent.startCharging(entity, 20.0f);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (this.grabComponent.getState() != GrabEntityComponent.GrabState.GRABBED) {
                this.grabComponent.release(entity);
            }
            if (!this.grabComponent.canContinueGrab(entity)) {
                this.cooldownComponent.startCooldown(entity, 180.0f);
            }
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.RAISE_ARMS);
    }

    public void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (!super.canUse(entity).isFail() && this.grabComponent.canContinueGrab(entity)) {
                LivingEntity target = this.grabComponent.getGrabbedEntity();
                entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1));
                target.func_195064_c(new EffectInstance((Effect)ModEffects.GRABBED.get(), 2, 3));
                target.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)target.func_70047_e(), entity.func_226281_cx_());
            } else {
                this.chargeComponent.stopCharging(entity);
            }
        }
    }

    public void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (this.grabComponent.hasGrabbedEntity()) {
            LivingEntity target = this.grabComponent.getGrabbedEntity();
            DamageSource source = this.dealDamageComponent.getDamageSource(entity);
            if (this.dealDamageComponent.hurtTarget(entity, target, 30.0f)) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 40, 0));
                target.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            }
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (float)3.0f);
            explosion.setStaticDamage(15.0f);
            explosion.setExplosionSound(true);
            explosion.setDamageOwner(false);
            explosion.setDestroyBlocks(true);
            explosion.setFireAfterExplosion(false);
            explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(1));
            explosion.setDamageEntities(true);
            explosion.setDamageSource(source);
            explosion.doExplosion();
            this.grabComponent.release(entity);
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 180.0f);
    }
}

