/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.riki;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class RikiLeapingAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"riki_leaping", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user increases the strength of their legs for a short while.", null)});
    private static final int HOLD_TIME = 100;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 300;
    public static final AbilityCore<RikiLeapingAbility> INSTANCE = new AbilityCore.Builder("Riki Leaping", AbilityCategory.DEVIL_FRUITS, RikiLeapingAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)100.0f, (float)300.0f), ContinuousComponent.getTooltip((float)100.0f), ChangeStatsComponent.getTooltip()}).build();
    private static final AbilityAttributeModifier JUMP_MODIFIER = new AbilityAttributeModifier(UUID.fromString("547a5eaa-a969-4328-9364-a40638876d54"), INSTANCE, "Riki Jump Modifier", 8.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AbilityAttributeModifier SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("547a5eaa-a969-4328-9364-a40638876d54"), INSTANCE, "Riki Speed Modifier", 0.1, AttributeModifier.Operation.ADDITION);
    private final DamageTakenComponent damageTakenComponent;
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent((IAbility)this);
    private boolean hasFallDamage;

    public RikiLeapingAbility(AbilityCore<RikiLeapingAbility> core) {
        super(core);
        this.isNew = true;
        this.damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.changeStatsComponent, this.damageTakenComponent});
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.JUMP_HEIGHT, (AttributeModifier)JUMP_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)SPEED_MODIFIER);
        this.hasFallDamage = true;
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 100.0f);
        this.hasFallDamage = false;
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.applyModifiers(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hasFallDamage = true;
        this.changeStatsComponent.removeModifiers(entity);
        float cooldown = 200.0f + this.continuousComponent.getContinueTime();
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            return 0.0f;
        }
        return damage;
    }

    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74757_a("hasFallDamage", this.hasFallDamage);
        return nbt;
    }

    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.hasFallDamage = nbt.func_74767_n("hasFallDamage");
    }
}

