/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.riki;

import net.MrMagicalCart.cartaddon.entities.projectiles.riki.MountatinTossProjectile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SwingTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class MountainTossAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"mountain_toss", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user picks up a mountain, and readies themselves to toss it.", null)});
    private static final float COOLDOWN = 900.0f;
    private static final float CHARGE_TIME = 75.0f;
    private static final float HOLD_TIME = 150.0f;
    private static final float startHeight = 10.5f;
    public static AbilityCore<MountainTossAbility> INSTANCE = new AbilityCore.Builder("Mountain Toss", AbilityCategory.DEVIL_FRUITS, MountainTossAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{DealDamageComponent.getTooltip((float)100.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{ChargeComponent.getTooltip((float)75.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{ContinuousComponent.getTooltip((float)150.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{CooldownComponent.getTooltip((float)900.0f)}).setSourceType(new SourceType[]{SourceType.PHYSICAL}).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final SwingTriggerComponent swingTriggerComponent = new SwingTriggerComponent((IAbility)this).addSwingEvent(this::onSwing);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private MountatinTossProjectile mountainTossProjectile;

    public MountainTossAbility(AbilityCore<MountainTossAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.continuousComponent, this.chargeComponent, this.swingTriggerComponent, this.animationComponent, this.projectileComponent});
        this.addCanUseCheck(AbilityHelper::requiresOnGround);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!(entity.field_70170_p.field_72995_K || this.chargeComponent.isCharging() || this.continuousComponent.isContinuous())) {
            this.chargeComponent.startCharging(entity, 75.0f);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        this.mountainTossProjectile = (MountatinTossProjectile)this.projectileComponent.getNewProjectile(entity);
        this.mountainTossProjectile.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e() + 10.5, entity.func_226281_cx_());
        entity.field_70170_p.func_217376_c((Entity)this.mountainTossProjectile);
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (this.mountainTossProjectile == null || !this.mountainTossProjectile.func_70089_S()) {
            this.chargeComponent.stopCharging(entity);
        }
        this.animationComponent.start(entity, ModAnimations.RAISE_ARMS);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 0, false, false));
        this.mountainTossProjectile.setLife(this.mountainTossProjectile.getMaxLife());
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 150.0f);
    }

    private void onSwing(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.mountainTossProjectile.setGravity(0.28f);
            this.mountainTossProjectile.setHasVelocityRotation();
            this.mountainTossProjectile.func_234612_a_((Entity)entity, entity.field_70125_A + 10.0f, entity.field_70177_z, 0.0f, 3.0f, 1.0f);
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (this.mountainTossProjectile != null && this.mountainTossProjectile.func_70089_S()) {
            this.mountainTossProjectile.setDamage(100.0f);
            if (entity.func_233570_aj_()) {
                this.mountainTossProjectile.setLife(this.mountainTossProjectile.getMaxLife());
                this.mountainTossProjectile.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e() + 10.5, entity.func_226281_cx_());
            } else {
                this.mountainTossProjectile.setLife(this.mountainTossProjectile.getMaxLife());
                this.mountainTossProjectile.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e() + 11.5, entity.func_226281_cx_());
            }
        } else {
            this.continuousComponent.stopContinuity(entity);
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 5, 2, false, false));
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (this.mountainTossProjectile != null && this.mountainTossProjectile.func_70089_S() && this.mountainTossProjectile.getLife() < this.mountainTossProjectile.getMaxLife()) {
                this.mountainTossProjectile.setGravity(0.28f);
                this.mountainTossProjectile.func_234612_a_((Entity)entity, entity.field_70125_A + 10.0f, entity.field_70177_z, 0.0f, 3.0f, 1.0f);
            }
            this.mountainTossProjectile = null;
            this.animationComponent.stop(entity);
            this.cooldownComponent.startCooldown(entity, 900.0f);
        }
    }

    private MountatinTossProjectile createProjectile(LivingEntity entity) {
        MountatinTossProjectile proj = new MountatinTossProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

