/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.revloyalty;

import net.MrMagicalCart.cartaddon.init.CartEntities;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class RallyingFlagAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"rallying_flag", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user calls some reinforcements.", null)});
    private static final float COOLDOWN = 1800.0f;
    public static final AbilityCore<RallyingFlagAbility> INSTANCE = new AbilityCore.Builder("Rallying Flag", AbilityCategory.FACTION, RallyingFlagAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)1800.0f)}).setUnlockCheck(RallyingFlagAbility::canUnlock).build();

    public RallyingFlagAbility(AbilityCore<RallyingFlagAbility> core) {
        super(core);
        this.isNew = true;
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        EntityType commander;
        BlockPos spawnPos;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        EntityType grunt = (EntityType)CartEntities.REV_GRUNTS.get();
        int i = 0;
        while ((double)i < WyHelper.randomWithRange((int)3, (int)7)) {
            spawnPos = WyHelper.findOnGroundSpawnLocation((World)entity.field_70170_p, (EntityType)grunt, (BlockPos)entity.func_233580_cy_(), (int)10);
            if (spawnPos != null) {
                grunt.func_220342_a((ServerWorld)entity.field_70170_p, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
            }
            ++i;
        }
        if (props.hasRevolutionaryRank(FactionHelper.RevolutionaryRank.COMMANDER)) {
            EntityType officer = (EntityType)CartEntities.REV_OFFICERS.get();
            int i2 = 0;
            while ((double)i2 < WyHelper.randomWithRange((int)1, (int)2)) {
                spawnPos = WyHelper.findOnGroundSpawnLocation((World)entity.field_70170_p, (EntityType)officer, (BlockPos)entity.func_233580_cy_(), (int)10);
                if (spawnPos != null) {
                    officer.func_220342_a((ServerWorld)entity.field_70170_p, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
                }
                ++i2;
            }
        }
        if (props.hasRevolutionaryRank(FactionHelper.RevolutionaryRank.CHIEF_OF_STAFF) && (spawnPos = WyHelper.findOnGroundSpawnLocation((World)entity.field_70170_p, (EntityType)(commander = (EntityType)CartEntities.REV_COMMANDERS.get()), (BlockPos)entity.func_233580_cy_(), (int)10)) != null) {
            commander.func_220342_a((ServerWorld)entity.field_70170_p, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
        }
        this.cooldownComponent.startCooldown(entity, 1800.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        return props.hasRevolutionaryRank(FactionHelper.RevolutionaryRank.OFFICER);
    }
}

