/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.pikaextra;

import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MaxAccelerationAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"max_acceleration", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user accelerates upwards, and dashes with immense speed, doing massive damage.", null)});
    private static final float COOLDOWN = 500.0f;
    private static final int CONTINUOUS_TIME = 30;
    private static final int CHARGE_TIME = 15;
    private static final float DAMAGE = 90.0f;
    private static final float RANGE = 2.5f;
    private static final float MAX_TELEPORT_DISTANCE = 85.0f;
    public static final AbilityCore<MaxAccelerationAbility> INSTANCE = new AbilityCore.Builder("Max Acceleration", AbilityCategory.DEVIL_FRUITS, MaxAccelerationAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)75.0f), ChargeComponent.getTooltip((float)10.0f), ContinuousComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)500.0f), RangeComponent.getTooltip((float)90.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.LIGHT).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuousEvent).addTickEvent(this::duringContinuousEvent).addEndEvent(this::endContinuityEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);

    public MaxAccelerationAbility(AbilityCore<MaxAccelerationAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.continuousComponent, this.dealDamageComponent, this.rangeComponent, this.animationComponent, this.hitTrackerComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous() && !this.chargeComponent.isCharging()) {
            this.continuousComponent.startContinuity(entity, 30.0f);
        }
    }

    private void startContinuousEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PIKA_CHARGE_SFX.get(), SoundCategory.PLAYERS, 50.0f, 1.0f);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 30, 0));
        Vector3d speed = WyHelper.propulsion((LivingEntity)entity, (double)1.0, (double)1.0);
        AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)4.0, (double)speed.field_72449_c);
    }

    private void duringContinuousEvent(LivingEntity entity, IAbility ability) {
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (float)3.0f);
        explosion.setExplosionSound(false);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setDamageEntities(false);
        explosion.doExplosion();
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.VANISH.get(), 5, 0, false, false));
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)-0.5);
        double i = mop.func_216347_e().field_72450_a;
        double j = mop.func_216347_e().field_72448_b;
        double k = mop.func_216347_e().field_72449_c;
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.JEWEL.get()), (Entity)entity, (double)i, (double)(j + 2.0), (double)k);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 15.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.VANISH.get(), 5, 0, false, false));
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)-0.5);
        double i = mop.func_216347_e().field_72450_a;
        double j = mop.func_216347_e().field_72448_b;
        double k = mop.func_216347_e().field_72449_c;
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.JEWEL.get()), (Entity)entity, (double)i, (double)j, (double)k);
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (float)3.0f);
        explosion.setExplosionSound(false);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setDamageEntities(false);
        explosion.doExplosion();
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        BlockPos blockpos = WyHelper.rayTraceBlockSafe((LivingEntity)entity, (float)90.0f);
        AbilityDamageSource source = (AbilityDamageSource)((ModDamageSource)this.dealDamageComponent.getDamageSource(entity));
        Vector3d startPos = entity.func_213303_ch();
        float actualTeleportDistance = 85.0f;
        for (double f = 0.0; f < 1.0; f += 0.13) {
            double z;
            double y;
            double x = MathHelper.func_219803_d((double)f, (double)startPos.func_82615_a(), (double)blockpos.func_177958_n());
            Vector3d pos = new Vector3d(x, y = MathHelper.func_219803_d((double)f, (double)startPos.func_82617_b(), (double)blockpos.func_177956_o()), z = MathHelper.func_219803_d((double)f, (double)startPos.func_82616_c(), (double)blockpos.func_177952_p()));
            List projectiles = WyHelper.getNearbyEntities((Vector3d)pos, (IWorld)entity.field_70170_p, (double)entity.func_213311_cf(), (double)entity.func_213302_cg(), (double)entity.func_213311_cf(), (Predicate)null, (Class[])new Class[]{ProjectileEntity.class});
            if (projectiles.isEmpty()) continue;
            projectiles.sort(TargetHelper.closestComparator((Vector3d)startPos));
            actualTeleportDistance = MathHelper.func_76133_a((double)((ProjectileEntity)projectiles.get(0)).func_195048_a(startPos));
            break;
        }
        blockpos = WyHelper.rayTraceBlockSafe((LivingEntity)entity, (float)actualTeleportDistance);
        List targets = this.rangeComponent.getTargetsInLine(entity, actualTeleportDistance, 5.5f);
        for (LivingEntity target : targets) {
            boolean flag;
            if (!this.hitTrackerComponent.canHit((Entity)target) || !(flag = this.dealDamageComponent.hurtTarget(entity, target, 75.0f, (DamageSource)source)) || entity.field_70170_p.field_72995_K) continue;
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.FLASH.get()), (Entity)target, (double)target.func_226277_ct_(), (double)(target.func_226278_cu_() + (double)target.func_70047_e()), (double)target.func_226281_cx_());
        }
        entity.func_184210_p();
        entity.func_223102_j((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PIKA_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 500.0f);
    }
}

