/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.opeextra;

import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedOpeHelper;
import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedRoomAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.opeextra.TaktTossProjectile;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.gen.Heightmap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TaktTossAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"takt_toss", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user lifts a chunk of earth, that can be tossed at their target. (Swing to toss)", null)});
    private static final int COOLDOWN = 200;
    private static final int CHARGE_TIME = 20;
    public static final AbilityCore<TaktTossAbility> INSTANCE = new AbilityCore.Builder("Takt Toss", AbilityCategory.DEVIL_FRUITS, TaktTossAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)25.0f, (float)60.0f), ChargeComponent.getTooltip((float)30.0f), CooldownComponent.getTooltip((float)200.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(this::endContinuityEvent);
    private Vector3d targetPos;
    private TaktTossProjectile rock = null;
    private boolean swung = false;

    public TaktTossAbility(AbilityCore<TaktTossAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.projectileComponent, this.chargeComponent, this.continuousComponent});
        this.addCanUseCheck(ReworkedOpeHelper::hasRoomActive);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous() && !this.chargeComponent.isCharging()) {
            this.chargeComponent.startCharging(entity, 20.0f);
        }
        if (this.continuousComponent.isContinuous()) {
            if (this.rock != null) {
                this.rock.setDamage(60.0f);
                this.rock.setCollideWithBlocks(true);
                this.rock.setTossed(true);
                this.rock.setCanGetStuckInGround();
            }
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.rock = null;
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && ReworkedOpeHelper.hasRoomActive(entity, (IAbility)this).isFail()) {
            this.chargeComponent.stopCharging(entity);
        }
        ReworkedRoomAbility abl = (ReworkedRoomAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(ReworkedRoomAbility.INSTANCE);
        if (this.targetPos == null) {
            RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)abl.getROOMSize());
            double i = mop.func_216347_e().field_72450_a;
            double k = mop.func_216347_e().field_72449_c;
            int y = entity.field_70170_p.func_201676_a(Heightmap.Type.WORLD_SURFACE, (int)i, (int)k);
            this.targetPos = new Vector3d(i, (double)y, k);
        }
        if (!entity.field_70170_p.field_72995_K) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.TAKT_EMERGENCE_IDLE.get()), (Entity)entity, (double)this.targetPos.field_72450_a, (double)this.targetPos.field_72448_b, (double)this.targetPos.field_72449_c);
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 2, 1, false, false));
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && this.rock == null) {
            this.rock = new TaktTossProjectile(entity.field_70170_p, entity);
            this.rock.func_70012_b(this.targetPos.field_72450_a, this.targetPos.field_72448_b - 6.0, this.targetPos.field_72449_c, 0.0f, 0.0f);
            this.rock.func_70186_c(0.0, 1.0, 0.0, 1.4f, 0.0f);
            entity.field_70170_p.func_217376_c((Entity)this.rock);
        }
        this.targetPos = null;
        this.continuousComponent.startContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && ReworkedOpeHelper.hasRoomActive(entity, (IAbility)this).isFail()) {
            this.continuousComponent.stopContinuity(entity);
        }
        if (entity.field_82175_bq && !this.swung && this.continuousComponent.getContinueTime() > 20.0f) {
            if (this.rock != null) {
                RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)80.0);
                double i = mop.func_216347_e().field_72450_a;
                double j = mop.func_216347_e().field_72448_b;
                double k = mop.func_216347_e().field_72449_c;
                Vector3d pos = new Vector3d(i, j, k);
                this.rock.func_200602_a(EntityAnchorArgument.Type.FEET, pos);
                double speed = 2.75;
                Vector3d move = new Vector3d(this.rock.func_70040_Z().field_72450_a * speed, this.rock.func_70040_Z().field_72448_b * speed, this.rock.func_70040_Z().field_72449_c * speed);
                this.rock.func_213293_j(move.field_72450_a, move.field_72448_b, move.field_72449_c);
                this.rock.setCollideWithBlocks(true);
                this.rock.setTossed(true);
                this.rock.setCanGetStuckInGround();
            }
            this.swung = true;
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.swung = false;
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private TaktTossProjectile createProjectile(LivingEntity entity) {
        TaktTossProjectile proj = new TaktTossProjectile(entity.field_70170_p, entity);
        return proj;
    }
}

