/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.opeextra;

import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedOpeHelper;
import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedRoomAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.opeextra.TaktEmergenceProjectile;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.gen.Heightmap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TaktEmergenceAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"takt_emergence", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user summons a spike within their ROOM.", null)});
    private static final int COOLDOWN = 160;
    private static final int CHARGE_TIME = 10;
    public static final AbilityCore<TaktEmergenceAbility> INSTANCE = new AbilityCore.Builder("Takt Emergence", AbilityCategory.DEVIL_FRUITS, TaktEmergenceAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)160.0f), ChargeComponent.getTooltip((float)10.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private Vector3d targetPos;

    public TaktEmergenceAbility(AbilityCore<TaktEmergenceAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.projectileComponent, this.chargeComponent});
        this.addCanUseCheck(ReworkedOpeHelper::hasRoomActive);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 10.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && ReworkedOpeHelper.hasRoomActive(entity, (IAbility)this).isFail()) {
            this.chargeComponent.stopCharging(entity);
        }
        ReworkedRoomAbility abl = (ReworkedRoomAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(ReworkedRoomAbility.INSTANCE);
        if (this.targetPos == null) {
            RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)abl.getROOMSize());
            double i = mop.func_216347_e().field_72450_a;
            double k = mop.func_216347_e().field_72449_c;
            int y = entity.field_70170_p.func_201676_a(Heightmap.Type.WORLD_SURFACE, (int)i, (int)k);
            this.targetPos = new Vector3d(i, (double)y, k);
        }
        if (!entity.field_70170_p.field_72995_K) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.TAKT_EMERGENCE_IDLE.get()), (Entity)entity, (double)this.targetPos.field_72450_a, (double)this.targetPos.field_72448_b, (double)this.targetPos.field_72449_c);
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 2, 1, false, false));
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            TaktEmergenceProjectile pillar = (TaktEmergenceProjectile)this.projectileComponent.getNewProjectile(entity);
            pillar.func_70012_b(this.targetPos.field_72450_a, this.targetPos.field_72448_b - 6.0, this.targetPos.field_72449_c, 0.0f, 0.0f);
            pillar.func_70186_c(0.0, 0.7, 0.0, 1.4f, 0.0f);
            entity.field_70170_p.func_217376_c((Entity)pillar);
        }
        this.cooldownComponent.startCooldown(entity, 160.0f);
        this.targetPos = null;
    }

    private TaktEmergenceProjectile createProjectile(LivingEntity entity) {
        TaktEmergenceProjectile proj = new TaktEmergenceProjectile(entity.field_70170_p, entity);
        return proj;
    }
}

