/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.opeextra;

import java.awt.Color;
import java.util.List;
import net.MrMagicalCart.cartaddon.abilities.opeextra.KRoomAnesthesiaAbility;
import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedOpeHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ShockWilleAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"shock_wille", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user charges their next attack, which has more range and more damage the longer it is charged. \u00a7aThis attack focuses on debuffing the opponent (Can use at 10% charge!)\u00a7r", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final int COOLDOWN = 700;
    public static final AbilityCore<ShockWilleAbility> INSTANCE = new AbilityCore.Builder("Shock Wille", AbilityCategory.DEVIL_FRUITS, ShockWilleAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)20.0f, (float)70.0f), ChargeComponent.getTooltip((float)100.0f), CooldownComponent.getTooltip((float)700.0f), RangeComponent.getTooltip((float)10.0f, (float)40.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).setSourceElement(SourceElement.LIGHTNING).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::tickChargeEvent).addEndEvent(this::endChargeEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private float range = 10.0f;
    private float damage = 20.0f;
    private boolean canceled = false;
    private LightningEntity bolt;

    public ShockWilleAbility(AbilityCore<ShockWilleAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.dealDamageComponent, this.animationComponent, this.rangeComponent, this.chargeComponent});
        this.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!ReworkedOpeHelper.hasKRoomActive(entity)) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You need to activate K-Room!"), entity.func_110124_au());
            return;
        }
        if (ReworkedOpeHelper.checkPunctureActive(entity)) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("Shock Wille cannot be used alongside Puncture Wille!"), entity.func_110124_au());
            return;
        }
        if (!this.chargeComponent.isCharging()) {
            this.chargeComponent.startCharging(entity, 100.0f);
        } else if ((double)this.chargeComponent.getChargePercentage() > 0.1) {
            this.chargeComponent.stopCharging(entity);
        }
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.range = 10.0f;
        this.damage = 20.0f;
        this.canceled = false;
        this.animationComponent.start(entity, ModAnimations.POINT_WEAPON);
    }

    private void tickChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 2, 2, false, false));
        if (!entity.field_70170_p.field_72995_K) {
            BlockRayTraceResult trace = WyHelper.rayTraceBlocks((Entity)entity, (double)0.25);
            if (this.bolt == null) {
                Direction dir = Direction.func_176733_a((double)entity.field_70177_z);
                Vector3d hitVec = trace.func_216347_e().func_72441_c((double)dir.func_82601_c(), (double)dir.func_96559_d(), (double)dir.func_82599_e());
                this.bolt = new LightningEntity((Entity)entity, hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, entity.field_70177_z, entity.field_70125_A, this.range, 10.0f, this.getCore());
                this.bolt.setColor(new Color(7794405));
                this.bolt.setMaxLife((int)(this.chargeComponent.getMaxChargeTime() * 1.2f));
                this.bolt.setDamage(0.0f);
                this.bolt.setSize(0.1f);
                this.bolt.setBranches(4);
                this.bolt.setSegments(1);
                this.bolt.setLightningMimic(false);
                entity.field_70170_p.func_217376_c((Entity)this.bolt);
            } else {
                Direction dir = Direction.func_176733_a((double)entity.field_70177_z);
                Vector3d hitVec = trace.func_216347_e().func_72441_c((double)dir.func_82601_c(), (double)dir.func_96559_d(), (double)dir.func_82599_e());
                this.bolt.func_70012_b(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, entity.field_70177_z, entity.field_70125_A);
                if (this.chargeComponent.getChargeTime() % 10.0f == 0.0f && this.bolt != null) {
                    this.bolt.func_70106_y();
                    this.bolt = null;
                }
            }
        }
        if (this.chargeComponent.getChargeTime() % 5.0f == 0.0f) {
            this.range += 1.5f;
            this.damage += 2.5f;
        }
        if (!ReworkedOpeHelper.hasKRoomActive(entity)) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("K-Room needs to be active!"), entity.func_110124_au());
            this.chargeComponent.stopCharging(entity);
            this.canceled = true;
        }
        if (!AbilityHelper.canUseSwordsmanAbilities((LivingEntity)entity)) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You need a sword to use this ability!"), entity.func_110124_au());
            this.chargeComponent.stopCharging(entity);
            this.canceled = true;
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.bolt != null) {
            this.bolt.func_70106_y();
            this.bolt = null;
        }
        this.animationComponent.stop(entity);
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        KRoomAnesthesiaAbility abl = (KRoomAnesthesiaAbility)props.getEquippedAbility(KRoomAnesthesiaAbility.INSTANCE);
        if (abl != null && abl.isContinuous()) {
            abl.setAbilityUsed(true);
        } else {
            this.canceled = true;
        }
        if (!this.canceled) {
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.EL_THOR_SFX.get(), SoundCategory.PLAYERS, 20.0f, 1.75f);
            BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)entity, (double)this.range);
            double beamDistance = Math.sqrt(entity.func_70092_e(mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c));
            float size = 0.25f;
            float length = this.range - 5.0f;
            Vector3d pos = VectorHelper.calculateRotationBasedOffsetPosition((Vector3d)entity.func_213303_ch(), (double)entity.field_70761_aq, (double)0.0, (double)1.15, (double)0.0);
            LightningEntity bolt = new LightningEntity((Entity)entity, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, entity.field_70177_z, entity.field_70125_A, length + (float)beamDistance, 20.0f, this.getCore());
            bolt.setBlocksAffectedLimit(4000);
            bolt.setMaxLife(55);
            bolt.setDamage(0.0f);
            bolt.setExplosion(4, true);
            bolt.setSize(size);
            bolt.setBoxSizeDivision(1.0);
            bolt.setColor(new Color(14276096));
            bolt.setAngle(100);
            bolt.setTargetTimeToReset(60);
            bolt.disableExplosionKnockback();
            bolt.setBranches(1);
            bolt.setSegments(1);
            entity.field_70170_p.func_217376_c((Entity)bolt);
            List list = this.rangeComponent.getTargetsInLine(entity, this.range, 4.5f);
            for (LivingEntity target : list) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 60, 0, false, false));
                target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 60, 0, false, false));
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 80, 0, false, false));
                target.func_195064_c(new EffectInstance(Effects.field_76419_f, 160, 0, false, false));
                target.func_195064_c(new EffectInstance(Effects.field_76421_d, 160, 1, false, false));
                this.dealDamageComponent.hurtTarget(entity, target, this.damage);
            }
        }
        this.cooldownComponent.startCooldown(entity, 700.0f);
    }
}

