/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.opeextra;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedOpeHelper;
import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedRoomAbility;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.api.protection.block.RestrictedBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.ope.TaktBlockEntity;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedTaktAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"takt", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user lifts entities its looking at, preventing them from moving freely.", null)});
    private static final float COOLDOWN = 240.0f;
    private static final float HOLD_TIME = 60.0f;
    public static final AbilityCore<ReworkedTaktAbility> INSTANCE = new AbilityCore.Builder("Takt", AbilityCategory.DEVIL_FRUITS, ReworkedTaktAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)240.0f), ContinuousComponent.getTooltip((float)60.0f)}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private List<Entity> grabbedEntities = new ArrayList<Entity>();

    public ReworkedTaktAbility(AbilityCore<ReworkedTaktAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.continuousComponent});
        super.addCanUseCheck(ReworkedOpeHelper::hasRoomActive);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        ReworkedRoomAbility abl = (ReworkedRoomAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(ReworkedRoomAbility.INSTANCE);
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)abl.getROOMSize());
        BlockPos blockPos = new BlockPos(mop.func_216347_e());
        if (mop.func_216346_c() == RayTraceResult.Type.BLOCK) {
            blockPos = new BlockPos((Vector3i)((BlockRayTraceResult)mop).func_216350_a());
        } else if (mop.func_216346_c() == RayTraceResult.Type.ENTITY) {
            blockPos = new BlockPos((Vector3i)((EntityRayTraceResult)mop).func_216348_a().func_233580_cy_());
        }
        Function mapper = pos -> {
            BlockState state = entity.field_70170_p.func_180495_p(pos);
            TaktBlockEntity fallingBlock = new TaktBlockEntity(entity.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), state);
            AbilityHelper.setDeltaMovement((Entity)fallingBlock, (double)0.0, (double)0.0, (double)0.0);
            fallingBlock.time = 5;
            fallingBlock.func_189654_d(true);
            fallingBlock.dropItem = false;
            entity.field_70170_p.func_217376_c((Entity)fallingBlock);
            entity.field_70170_p.func_217377_a(pos, true);
            return fallingBlock;
        };
        Stream<Object> var10000 = WyHelper.getNearbyBlocks((BlockPos)blockPos, (IWorld)entity.field_70170_p, (int)2, ReworkedTaktAbility.isPositionGriefable(entity), (List)ImmutableList.of((Object)Blocks.field_150350_a)).stream().map(mapper);
        List<Entity> var10001 = this.grabbedEntities;
        var10000.forEach(var10001::add);
        var10000 = WyHelper.getNearbyLiving((Vector3d)mop.func_216347_e(), (IWorld)entity.field_70170_p, (double)2.0, (Predicate)ModEntityPredicates.getEnemyFactions((LivingEntity)entity)).stream().filter(ModEntityPredicates.IS_ALIVE_AND_SURVIVAL).filter(living -> abl.isPositionInRoom(living.func_233580_cy_()));
        var10001 = this.grabbedEntities;
        var10000.forEach(var10001::add);
        if (!this.grabbedEntities.isEmpty()) {
            this.continuousComponent.triggerContinuity(entity, 60.0f);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (!super.canUse(entity).isFail() && !this.grabbedEntities.isEmpty()) {
                ReworkedRoomAbility abl = (ReworkedRoomAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(ReworkedRoomAbility.INSTANCE);
                this.grabbedEntities.stream().forEach(target -> {
                    target.field_70125_A = target.field_70127_C;
                    target.field_70177_z = target.field_70126_B;
                    Random rand = new Random(target.hashCode());
                    double offsetX = WyHelper.randomWithRange((Random)rand, (int)-2, (int)2);
                    double offsetY = WyHelper.randomWithRange((Random)rand, (int)-2, (int)2);
                    double offsetZ = WyHelper.randomWithRange((Random)rand, (int)-2, (int)2);
                    double distance = 8.0;
                    Vector3d lookVec = entity.func_70040_Z();
                    Vector3d pos = new Vector3d(lookVec.field_72450_a * distance + offsetX, (double)entity.func_70047_e() / 2.0 + lookVec.field_72448_b * distance + offsetY, lookVec.field_72449_c * distance + offsetZ);
                    if (target instanceof LivingEntity && abl.isPositionInRoom(target.func_233580_cy_()) || ReworkedTaktAbility.isPositionGriefable(entity).test((Object)target.func_233580_cy_())) {
                        AbilityHelper.setDeltaMovement((Entity)target, (Vector3d)entity.func_213303_ch().func_178787_e(pos).func_178788_d(target.func_213303_ch()));
                        if (target instanceof ServerPlayerEntity) {
                            EnumSet<SPlayerPositionLookPacket.Flags> flags = EnumSet.of(SPlayerPositionLookPacket.Flags.X, SPlayerPositionLookPacket.Flags.Y, SPlayerPositionLookPacket.Flags.Z);
                            ((ServerPlayerEntity)target).field_71135_a.func_175089_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), target.field_70126_B, target.field_70127_C, flags);
                        }
                    }
                    target.field_70143_R = 0.0f;
                });
            } else {
                this.continuousComponent.stopContinuity(entity);
            }
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.grabbedEntities.stream().filter(Entity::func_189652_ae).forEach(e -> e.func_189654_d(false));
        this.grabbedEntities.clear();
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private static com.google.common.base.Predicate<BlockPos> isPositionGriefable(LivingEntity entity) {
        ReworkedRoomAbility abl = (ReworkedRoomAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(ReworkedRoomAbility.INSTANCE);
        ProtectedAreasData worldData = ProtectedAreasData.get((World)entity.field_70170_p);
        return pos -> {
            boolean isGriefDisabled;
            boolean bl = isGriefDisabled = !CommonConfig.INSTANCE.isAbilityGriefingEnabled();
            if (isGriefDisabled) {
                return false;
            }
            ProtectedArea area = worldData.getProtectedArea(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (area != null && !area.canDestroyBlocks()) {
                return false;
            }
            if (!abl.isPositionInRoom((BlockPos)pos)) {
                return false;
            }
            BlockState state = entity.field_70170_p.func_180495_p(pos);
            boolean isBlockBanned = RestrictedBlockProtectionRule.INSTANCE.isBanned(state);
            return !isBlockBanned;
        };
    }
}

