/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.opeextra;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedOpeHelper;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.math.EasingFunctionHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.entities.SphereEntity;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class ReworkedRoomAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"room", (Pair[])new Pair[]{ImmutablePair.of((Object)"Creates a spherical space around the user in which they can manipulate anything or use other skills", null)});
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(new BlockProtectionRule[]{AirBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE, LiquidBlockProtectionRule.INSTANCE}).addApprovedBlocks(new RegistryObject[]{ModBlocks.OPE}).setBypassGriefRule().build();
    public static final int MIN_ROOM_SIZE = 8;
    public static final int MAX_ROOM_SIZE = 82;
    public static final int MAX_THRESHOLD = 2;
    private static final int CHARGE_TIME = 70;
    private static final float MIN_COOLDOWN = 10.0f;
    private static final float MAX_COOLDOWN = 70.0f;
    public static final AbilityCore<ReworkedRoomAbility> INSTANCE = new AbilityCore.Builder("ROOM", AbilityCategory.DEVIL_FRUITS, ReworkedRoomAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)10.0f, (float)70.0f), ChargeComponent.getTooltip((float)50.0f), RangeComponent.getTooltip((float)8.0f, (float)82.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.ROOM, new AbilityPool2[0]);
    private SphereEntity roomEntity;
    private List<BlockPos> blockList = new ArrayList<BlockPos>();
    private List<BlockPos> placedBlockList = new ArrayList<BlockPos>();
    private int roomSize = 0;
    private BlockPos centerPos;
    private boolean isShrinking = false;
    private Interval checkPositionInterval = new Interval(20);
    private Interval playSoundInterval = new Interval(18);

    public ReworkedRoomAbility(AbilityCore<ReworkedRoomAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.chargeComponent, this.continuousComponent, this.poolComponent});
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (ReworkedOpeHelper.checkKRoomActive(entity)) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("ROOM can't be used alongside K-Room!"), entity.func_110124_au());
            return;
        }
        if (this.chargeComponent.isCharging()) {
            this.chargeComponent.stopCharging(entity);
        } else if (this.continuousComponent.isContinuous()) {
            if (CommonConfig.INSTANCE.isExperiementalSpheresEnabled()) {
                this.isShrinking = true;
                this.chargeComponent.startCharging(entity, 30.0f);
                return;
            }
            this.continuousComponent.stopContinuity(entity);
        } else {
            this.checkPositionInterval.restartIntervalToZero();
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.ROOM_CREATE_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
            this.isShrinking = false;
            this.setupSphere(entity);
            float entityHpDebuff = 2.0f - entity.func_110143_aJ() / entity.func_110138_aP();
            float chargeTime = 70.0f * entityHpDebuff;
            this.chargeComponent.startCharging(entity, chargeTime);
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        this.chargeTickSphere(entity);
        if (this.playSoundInterval.canTick()) {
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.ROOM_CHARGE_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.endChargeSphere(entity);
            this.endChargeBlocks(entity);
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.ROOM_EXPAND_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
            this.continuousComponent.startContinuity(entity, -1.0f);
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K || !this.continuityTickSphere(entity) || this.continuityTickBlocks(entity)) {
            // empty if block
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.continuityEndBlocks(entity);
        this.continuityEndSphere(entity);
        this.centerPos = null;
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.ROOM_CLOSE_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
        float entityHpDebuff = 2.0f - entity.func_110143_aJ() / entity.func_110138_aP();
        float roomSizeDebuff = this.roomSize / 82;
        float cooldown = 10.0f * entityHpDebuff * roomSizeDebuff;
        cooldown = MathHelper.func_76131_a((float)cooldown, (float)10.0f, (float)70.0f);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private void setupSphere(LivingEntity entity) {
        if (CommonConfig.INSTANCE.isExperiementalSpheresEnabled()) {
            this.roomEntity = new SphereEntity(entity.field_70170_p, entity);
            this.roomEntity.setColor(new Color(0, 255, 255, 50));
            this.roomEntity.setRadius(0.0f);
            this.roomEntity.setDetailLevel(32);
            this.roomEntity.setAnimationSpeed(1);
            entity.field_70170_p.func_217376_c((Entity)this.roomEntity);
            this.centerPos = this.roomEntity.func_233580_cy_();
        }
    }

    private void chargeTickSphere(LivingEntity entity) {
        if (CommonConfig.INSTANCE.isExperiementalSpheresEnabled() && this.roomEntity != null) {
            float radius = 0.0f;
            if (this.isShrinking) {
                radius = (float)this.roomSize * (1.0f - this.chargeComponent.getChargePercentage()) / 82.0f;
                radius = EasingFunctionHelper.easeOutCubic((Float)Float.valueOf(radius)) * 82.0f;
            } else {
                radius = 82.0f * this.chargeComponent.getChargePercentage() / 82.0f;
                radius = EasingFunctionHelper.easeInCubic((Float)Float.valueOf(radius)) * 82.0f;
            }
            this.roomEntity.setRadius(radius);
            this.roomSize = (int)radius;
        }
    }

    private void endChargeSphere(LivingEntity entity) {
        if (CommonConfig.INSTANCE.isExperiementalSpheresEnabled() && !entity.field_70170_p.field_72995_K) {
            if (this.isShrinking) {
                if (this.roomEntity != null) {
                    this.roomEntity.func_70106_y();
                }
                this.roomEntity = null;
            } else {
                float radius = MathHelper.func_76131_a((float)(82.0f * this.chargeComponent.getChargePercentage()), (float)8.0f, (float)82.0f);
                this.roomEntity.setRadius(radius);
                this.roomSize = (int)radius;
            }
        }
    }

    private boolean continuityTickSphere(LivingEntity entity) {
        if (!CommonConfig.INSTANCE.isExperiementalSpheresEnabled()) {
            return true;
        }
        if (this.checkPositionInterval.canTick() && !this.isEntityInRoom((Entity)entity)) {
            this.continuousComponent.stopContinuity(entity);
            return false;
        }
        if (this.roomEntity != null && this.roomEntity.func_70089_S()) {
            return true;
        }
        this.continuousComponent.stopContinuity(entity);
        return false;
    }

    private void continuityEndSphere(LivingEntity entity) {
        if (CommonConfig.INSTANCE.isExperiementalSpheresEnabled()) {
            if (this.roomEntity != null) {
                this.roomEntity.func_70106_y();
            }
            this.roomEntity = null;
        }
    }

    private void endChargeBlocks(LivingEntity entity) {
        if (!CommonConfig.INSTANCE.isExperiementalSpheresEnabled() && this.blockList.isEmpty()) {
            this.roomSize = Math.max(8, (int)(82.0f * this.chargeComponent.getChargeTime() / this.chargeComponent.getMaxChargeTime()));
            this.centerPos = new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            this.blockList.addAll(AbilityHelper.createSphere((World)entity.field_70170_p, (BlockPos)entity.func_233580_cy_(), (int)this.roomSize, (boolean)true, (Block)((Block)ModBlocks.OPE.get()), (int)0, (BlockProtectionRule)GRIEF_RULE));
            this.placedBlockList.addAll(this.blockList);
        }
    }

    private boolean continuityTickBlocks(LivingEntity entity) {
        if (CommonConfig.INSTANCE.isExperiementalSpheresEnabled()) {
            return true;
        }
        if (this.centerPos != null && this.checkPositionInterval.canTick() && !this.isPositionInRoom(entity.func_233580_cy_())) {
            this.continuousComponent.stopContinuity(entity);
            return false;
        }
        int placedBlocks = 0;
        Iterator<BlockPos> iter = this.placedBlockList.iterator();
        do {
            if (!iter.hasNext()) {
                return true;
            }
            BlockPos pos = iter.next();
            entity.field_70170_p.func_184138_a(pos, Blocks.field_150350_a.func_176223_P(), ((Block)ModBlocks.OPE.get()).func_176223_P(), 0);
            iter.remove();
        } while (++placedBlocks <= 512);
        return false;
    }

    private void continuityEndBlocks(LivingEntity entity) {
        if (!CommonConfig.INSTANCE.isExperiementalSpheresEnabled()) {
            for (BlockPos pos : this.blockList) {
                Block currentBlock = entity.field_70170_p.func_180495_p(pos).func_177230_c();
                if (currentBlock != ModBlocks.OPE.get()) continue;
                entity.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
            this.blockList.clear();
            this.placedBlockList.clear();
        }
    }

    public int getROOMSize() {
        return this.roomSize;
    }

    public BlockPos getCenterBlock() {
        return this.centerPos;
    }

    public boolean isEntityInRoom(Entity entity) {
        if (this.roomEntity == null) {
            return false;
        }
        if (this.isPositionInRoom(entity.func_233580_cy_())) {
            return true;
        }
        return entity.func_70068_e((Entity)this.roomEntity) <= (double)(this.roomSize * this.roomSize);
    }

    public boolean isPositionInRoom(BlockPos pos) {
        return this.centerPos == null ? false : pos.func_218141_a((Vector3i)this.centerPos, (double)this.roomSize);
    }
}

