/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.opeextra;

import net.MrMagicalCart.cartaddon.abilities.opeextra.KRoomAnesthesiaAbility;
import net.MrMagicalCart.cartaddon.abilities.opeextra.PunctureWilleAbility;
import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedRoomAbility;
import net.MrMagicalCart.cartaddon.abilities.opeextra.ShockWilleAbility;
import net.MrMagicalCart.cartaddon.abilities.opeextra.TaktControlAbility;
import net.MrMagicalCart.cartaddon.init.CartI18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class ReworkedOpeHelper {
    public static AbilityUseResult hasRoomActive(LivingEntity entity, IAbility ability) {
        ReworkedRoomAbility roomAbility = (ReworkedRoomAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(ReworkedRoomAbility.INSTANCE);
        return roomAbility != null && roomAbility.isEntityInRoom((Entity)entity) ? AbilityUseResult.success() : AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_ROOM, new Object[]{ability.getDisplayName()}));
    }

    public static Ability.ICanUseEvent<LivingEntity, IAbility> requireTaktControl(int neededStacks) {
        return (entity, ability) -> {
            TaktControlAbility control = (TaktControlAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(TaktControlAbility.INSTANCE);
            if (control != null && control.isContinuous()) {
                int controlStacks = control.getComponent(ModAbilityKeys.STACK).map(comp -> comp.getStacks()).orElse(0);
                if (controlStacks - neededStacks < 0) {
                    TranslationTextComponent message = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_ABILITY_STACKS, new Object[]{neededStacks, TaktControlAbility.INSTANCE.getLocalizedName().getString()});
                    return AbilityUseResult.fail((ITextComponent)message);
                }
                return AbilityUseResult.success();
            }
            return AbilityUseResult.fail((ITextComponent)CartI18n.ABILITY_MESSAGE_NEED_TAKT_CONTROL);
        };
    }

    public static boolean hasKRoomActive(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        if (props == null) {
            return false;
        }
        Ability abl = (Ability)props.getEquippedAbility(KRoomAnesthesiaAbility.INSTANCE);
        if (abl == null) {
            return false;
        }
        return abl.isContinuous();
    }

    public static boolean checkKRoomActive(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        if (props == null) {
            return false;
        }
        Ability abl = (Ability)props.getEquippedAbility(KRoomAnesthesiaAbility.INSTANCE);
        if (abl == null) {
            return false;
        }
        return abl.isContinuous() || abl.isCharging();
    }

    public static boolean checkRoomActive(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        if (props == null) {
            return false;
        }
        Ability abl = (Ability)props.getEquippedAbility(ReworkedRoomAbility.INSTANCE);
        if (abl == null) {
            return false;
        }
        return abl.isContinuous() || abl.isCharging();
    }

    public static boolean checkShockActive(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        if (props == null) {
            return false;
        }
        Ability abl = (Ability)props.getEquippedAbility(ShockWilleAbility.INSTANCE);
        if (abl == null) {
            return false;
        }
        return abl.isContinuous() || abl.isCharging();
    }

    public static boolean checkPunctureActive(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        if (props == null) {
            return false;
        }
        Ability abl = (Ability)props.getEquippedAbility(PunctureWilleAbility.INSTANCE);
        if (abl == null) {
            return false;
        }
        return abl.isContinuous() || abl.isCharging();
    }
}

