/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.opeextra;

import java.util.List;
import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedOpeHelper;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedInjectionShotAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"injection_shot", (Pair[])new Pair[]{ImmutablePair.of((Object)"While holding a weapon, the user charges at the enemy, leaving them confused.", null)});
    private static final float COOLDOWN = 200.0f;
    private static final float DAMAGE = 40.0f;
    private static final float RANGE = 2.5f;
    public static final AbilityCore<ReworkedInjectionShotAbility> INSTANCE = new AbilityCore.Builder("Injection Shot", AbilityCategory.DEVIL_FRUITS, ReworkedInjectionShotAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)40.0f), ChargeComponent.getTooltip((float)10.0f), ContinuousComponent.getTooltip((float)10.0f), CooldownComponent.getTooltip((float)200.0f), RangeComponent.getTooltip((float)2.5f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.SLASH}).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);

    public ReworkedInjectionShotAbility(AbilityCore<ReworkedInjectionShotAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.chargeComponent, this.continuousComponent, this.dealDamageComponent, this.hitTrackerComponent, this.animationComponent, this.rangeComponent});
        super.addCanUseCheck(ReworkedOpeHelper::hasRoomActive);
        super.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (AbilityHelper.canUseMomentumAbilities((LivingEntity)entity) && !this.chargeComponent.isCharging() && !this.continuousComponent.isContinuous()) {
            this.chargeComponent.startCharging(entity, 20.0f);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.POINT_WEAPON);
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (super.canUse(entity).isFail()) {
                this.chargeComponent.stopCharging(entity);
            }
            AbilityHelper.slowEntityFall((LivingEntity)entity);
            AbilityHelper.setDeltaMovement((Entity)entity, (double)0.0, (double)0.0, (double)0.0);
            Vector3d look = entity.func_70040_Z().func_72432_b().func_186678_a(2.0);
            if (this.continuousComponent.getContinueTime() % 2.0f == 0.0f) {
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.INJECTION.get()), (Entity)entity, (double)(entity.func_226277_ct_() + look.field_72450_a), (double)(entity.func_226278_cu_() + 0.25 + look.field_72448_b), (double)(entity.func_226281_cx_() + look.field_72449_c));
            }
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (super.canUse(entity).isSuccess()) {
                this.continuousComponent.startContinuity(entity, 10.0f);
            } else {
                this.continuousComponent.stopContinuity(entity);
            }
        }
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.hitTrackerComponent.clearHits();
            Vector3d look = entity.func_70040_Z();
            Vector3d speed = look.func_216372_d(7.0, 0.0, 7.0).func_72441_c(0.0, 0.2, 0.0);
            AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)speed.field_72448_b, (double)speed.field_72449_c);
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (super.canUse(entity).isFail()) {
                this.continuousComponent.stopContinuity(entity);
            } else if (entity.func_70089_S()) {
                List targets = this.rangeComponent.getTargetsInArea(entity, 2.5f);
                ModDamageSource source = ((AbilityDamageSource)this.dealDamageComponent.getDamageSource(entity)).setSlash().setPiercing(0.75f);
                targets.remove(entity);
                for (LivingEntity target : targets) {
                    if (!this.hitTrackerComponent.canHit((Entity)entity) || !this.dealDamageComponent.hurtTarget(entity, target, 40.0f, (DamageSource)source)) continue;
                    target.func_195064_c(new EffectInstance(Effects.field_76431_k, 60, 0));
                }
            }
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        AbilityHelper.setDeltaMovement((Entity)entity, (double)0.0, (double)0.0, (double)0.0);
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

