/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.opeextra;

import java.util.UUID;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedOpeHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ItemSpawnComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;

public class ReworkedGammaKnifeAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"gamma_knife", (Pair[])new Pair[]{ImmutablePair.of((Object)"Creates a blade of gamma radiation which massively damages the opponent's organs", null)});
    private static final float COOLDOWN = 500.0f;
    public static final AbilityCore<ReworkedGammaKnifeAbility> INSTANCE = new AbilityCore.Builder("Gamma Knife", AbilityCategory.DEVIL_FRUITS, ReworkedGammaKnifeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)500.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.SLASH}).build();
    private final ItemSpawnComponent itemSpawnComponent = new ItemSpawnComponent((IAbility)this);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("cfcd7ec3-d1fe-4409-9449-2be6f9b9f9ab"), INSTANCE, "Gamma Knife Strength Modifier", 70.0, AttributeModifier.Operation.ADDITION);

    public ReworkedGammaKnifeAbility(AbilityCore<ReworkedGammaKnifeAbility> core) {
        super(core);
        this.continuousComponent.addStartEvent(100, this::onContinuityStart).addTickEvent(100, this::onContinuityTick).addEndEvent(100, this::onContinuityEnd);
        this.statsComponent.addAttributeModifier(Attributes.field_233823_f_, (AttributeModifier)STRENGTH_MODIFIER, this.canActivate());
        super.addComponents(new AbilityComponent[]{this.itemSpawnComponent});
        super.addCanUseCheck(ReworkedOpeHelper::hasRoomActive);
        super.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.itemSpawnComponent.spawnItem(entity, new ItemStack((IItemProvider)ModWeapons.GAMMA_KNIFE.get()), EquipmentSlotType.MAINHAND, true);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && ReworkedOpeHelper.hasRoomActive(entity, (IAbility)this).isFail()) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.itemSpawnComponent.despawnItems(entity);
    }

    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        source.bypassLogia().setPiercing(1.0f);
        return true;
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_77973_b().equals(ModWeapons.GAMMA_KNIFE.get());
    }

    public int getUseLimit() {
        return 1;
    }

    public boolean isParallel() {
        return true;
    }

    public float getPunchCooldown() {
        return 500.0f;
    }
}

