/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.opeextra;

import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedOpeHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedCounterShockAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"counter_shock", (Pair[])new Pair[]{ImmutablePair.of((Object)"Releases an electrical surge like a defibrillator from the users fist which shocks the opponent.", null)});
    private static final float COOLDOWN = 200.0f;
    public static final AbilityCore<ReworkedCounterShockAbility> INSTANCE = new AbilityCore.Builder("Counter Shock", AbilityCategory.DEVIL_FRUITS, ReworkedCounterShockAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)200.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).setSourceElement(SourceElement.SHOCKWAVE).build();

    public ReworkedCounterShockAbility(AbilityCore<ReworkedCounterShockAbility> core) {
        super(core);
        this.continuousComponent.addTickEvent(100, this::onContinuityTick);
        this.addCanUseCheck(ReworkedOpeHelper::hasRoomActive);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && ReworkedOpeHelper.hasRoomActive(entity, (IAbility)this).isFail()) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0));
        target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 10, 0));
        target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 40, 0));
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (float)2.0f);
        explosion.setStaticDamage(3.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(false);
        explosion.setFireAfterExplosion(false);
        explosion.setSmokeParticles((ParticleEffect)new CommonExplosionParticleEffect(1));
        explosion.setDamageEntities(false);
        explosion.doExplosion();
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.COUNTER_SHOCK.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)target.func_226278_cu_(), (double)target.func_226281_cx_());
        return true;
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    public float getPunchDamage() {
        return 40.0f;
    }

    public float getPunchCooldown() {
        return 200.0f;
    }

    public int getUseLimit() {
        return 1;
    }
}

