/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.opeextra;

import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedOpeHelper;
import net.MrMagicalCart.cartaddon.entities.projectiles.opeextra.ReworkedSpatialSlashProjectile;
import net.MrMagicalCart.cartaddon.init.CartAnimations;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.HandSide;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;

public class ReworkedAmputateAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"amputate", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user launches a slash within their room, which stun targets. Increased effects when your haki is stronger.", null)});
    private static final float COOLDOWN = 240.0f;
    public static final AbilityCore<ReworkedAmputateAbility> INSTANCE = new AbilityCore.Builder("Amputate", AbilityCategory.DEVIL_FRUITS, ReworkedAmputateAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)240.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);

    public ReworkedAmputateAbility(AbilityCore<ReworkedAmputateAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.projectileComponent, this.animationComponent});
        this.addCanUseCheck(ReworkedOpeHelper::hasRoomActive);
        this.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 6.0f, 1.2f);
        if (entity.func_184591_cq() == HandSide.LEFT) {
            this.animationComponent.start(entity, CartAnimations.DIVINE_DEPARTURE_LEFT, 7);
        } else {
            this.animationComponent.start(entity, CartAnimations.DESTROYER_OF_DEATH_RIGHT, 7);
        }
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private ReworkedSpatialSlashProjectile createProjectile(LivingEntity entity) {
        ReworkedSpatialSlashProjectile proj = new ReworkedSpatialSlashProjectile(entity.field_70170_p, entity);
        return proj;
    }
}

