/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.opeextra;

import java.util.List;
import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedOpeHelper;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class RadioKnifeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"radio_knife", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user slashes the air rapidly, dealing damage to targets in front of them.", null)});
    private static final float COOLDOWN = 300.0f;
    private static final int CHARGE_TIME = 40;
    private static final float DAMAGE = 5.0f;
    private static final float RANGE = 4.0f;
    private final Interval damageInterval = new Interval(4);
    public static final AbilityCore<RadioKnifeAbility> INSTANCE = new AbilityCore.Builder("Radio Knife", AbilityCategory.DEVIL_FRUITS, RadioKnifeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)50.0f), ChargeComponent.getTooltip((float)40.0f), CooldownComponent.getTooltip((float)240.0f), RangeComponent.getTooltip((float)4.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceType(new SourceType[]{SourceType.SLASH}).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);

    public RadioKnifeAbility(AbilityCore<RadioKnifeAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.dealDamageComponent, this.rangeComponent, this.animationComponent, this.hitTrackerComponent});
        super.addCanUseCheck(ReworkedOpeHelper::hasRoomActive);
        super.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 40.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (!(entity.field_70170_p.field_72995_K || !ReworkedOpeHelper.hasRoomActive(entity, (IAbility)this).isFail() && AbilityHelper.canUseSwordsmanAbilities((LivingEntity)entity))) {
            this.chargeComponent.stopCharging(entity);
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 5, 1, false, false));
        List targets = this.rangeComponent.getTargetsInLine(entity, 4.0f, 4.0f);
        for (LivingEntity target : targets) {
            if (this.hitTrackerComponent.canHit((Entity)target) && this.damageInterval.canTick() && this.dealDamageComponent.hurtTarget(entity, target, 5.0f)) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 2, 0, false, false));
                target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1, false, false));
                target.func_195064_c(new EffectInstance((Effect)ModEffects.NO_HANDS.get(), 20, 0));
            }
            this.hitTrackerComponent.clearHits();
        }
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)3.0);
        double x = mop.func_216347_e().field_72450_a + WyHelper.randomDouble();
        double z = mop.func_216347_e().field_72449_c + WyHelper.randomDouble();
        double y = mop.func_216347_e().field_72448_b + WyHelper.randomDouble();
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.RADIO_KNIFE.get()), (Entity)entity, (double)x, (double)y, (double)z);
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.LIGHTNING_TELEPORT.get(), SoundCategory.PLAYERS, 3.0f, 1.45f);
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }
}

