/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.opeextra;

import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedOpeHelper;
import net.MrMagicalCart.cartaddon.init.CartEffects;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class PerennialYouthOperationAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"perennial_youth_operation", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user boosts their target with buffs. However, they also hurt themselves in the process.", null)});
    private static final float COOLDOWN = 3600.0f;
    public static final AbilityCore<PerennialYouthOperationAbility> INSTANCE = new AbilityCore.Builder("Perennial Youth Operation", AbilityCategory.DEVIL_FRUITS, PerennialYouthOperationAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)3600.0f)}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addTryHitEvent(this::tryHitEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private LivingEntity target = null;

    public PerennialYouthOperationAbility(AbilityCore<PerennialYouthOperationAbility> core) {
        super(core);
        this.isNew = true;
        this.hitTriggerComponent.setBypassSameGroupProtection();
        super.addComponents(new AbilityComponent[]{this.continuousComponent, this.hitTriggerComponent, this.dealDamageComponent});
        this.addCanUseCheck(ReworkedOpeHelper::hasRoomActive);
        super.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!((double)entity.func_110143_aJ() > (double)entity.func_110138_aP() * 0.5)) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You need above 50% health to use Perennial Youth Operation!"), entity.func_110124_au());
            return;
        }
        this.continuousComponent.triggerContinuity(entity, 60.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.target = null;
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (this.target != null) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (this.target != null) {
            this.target.func_195064_c(new EffectInstance(Effects.field_76429_m, 600, 1));
            this.target.func_195064_c(new EffectInstance((Effect)CartEffects.PERENNIAL_YOUTH.get(), 600, 0, false, false));
            this.target.func_195064_c(new EffectInstance(Effects.field_76444_x, 600, 3));
            this.target.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 0));
            this.dealDamageComponent.hurtTarget(this.target, entity, entity.func_110143_aJ() / 2.0f, ModDamageSource.SOULBOUND_DAMAGE);
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 200, 0, false, false));
            entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 1, false, false));
            entity.func_195064_c(new EffectInstance(Effects.field_76437_t, 200, 1, false, false));
            entity.func_195064_c(new EffectInstance(Effects.field_76419_f, 200, 1, false, false));
        }
        this.target = null;
        this.cooldownComponent.startCooldown(entity, 3600.0f);
    }

    private HitTriggerComponent.HitResult tryHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous() && AbilityHelper.canUseSwordsmanAbilities((LivingEntity)entity)) {
            this.target = target;
            return HitTriggerComponent.HitResult.FAIL;
        }
        return HitTriggerComponent.HitResult.PASS;
    }
}

