/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.opeextra;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedOpeHelper;
import net.MrMagicalCart.cartaddon.abilities.opeextra.ReworkedRoomAbility;
import net.MrMagicalCart.cartaddon.init.CartEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.entities.SphereEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class JinkakuIshokuShujutsuAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"jinkaku_ishoku_shujutsu", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user swaps the position of any non-player entity, disorienting them and preventing them from using abilities for a short while.", null)});
    private static final float COOLDOWN = 300.0f;
    public static final AbilityCore<JinkakuIshokuShujutsuAbility> INSTANCE = new AbilityCore.Builder("Jinkaku Ishoku Shujutsu", AbilityCategory.DEVIL_FRUITS, JinkakuIshokuShujutsuAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)300.0f)}).build();
    private static final Predicate<Entity> SHAMBLES_LIST = target -> {
        if (target instanceof LightningEntity) {
            return false;
        }
        if (target instanceof SphereEntity) {
            return false;
        }
        return !(target.getEntity() instanceof AbilityProjectileEntity) || ((AbilityProjectileEntity)target.getEntity()).isPhysical();
    };

    public JinkakuIshokuShujutsuAbility(AbilityCore<JinkakuIshokuShujutsuAbility> core) {
        super(core);
        this.isNew = true;
        super.addCanUseCheck(ReworkedOpeHelper::hasRoomActive);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        int i;
        this.cooldownComponent.startCooldown(entity, 300.0f);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 0.5f, 0.75f);
        ReworkedRoomAbility reworkedRoomAbility = (ReworkedRoomAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(ReworkedRoomAbility.INSTANCE);
        BlockPos centerPos = reworkedRoomAbility.getCenterBlock();
        Vector3d centerVec = new Vector3d((double)centerPos.func_177958_n(), (double)centerPos.func_177956_o(), (double)centerPos.func_177952_p());
        Predicate<Entity> groupCheck = ModEntityPredicates.getEnemyFactions((LivingEntity)entity).and(SHAMBLES_LIST);
        List targets = WyHelper.getNearbyEntities((Vector3d)centerVec, (IWorld)entity.field_70170_p, (double)reworkedRoomAbility.getROOMSize(), groupCheck, (Class[])new Class[]{Entity.class});
        Collections.shuffle(targets);
        for (i = 0; i < targets.size(); ++i) {
            if (!(targets.get(i) instanceof PlayerEntity)) continue;
            targets.remove(i);
        }
        for (i = 0; i < targets.size() && i < targets.size() && i + 1 < targets.size(); i += 2) {
            Entity target1 = (Entity)targets.get(i);
            Entity target2 = (Entity)targets.get(i + 1);
            if (!reworkedRoomAbility.isPositionInRoom(target1.func_233580_cy_()) || !reworkedRoomAbility.isPositionInRoom(target2.func_233580_cy_())) continue;
            float[] beforeCoords = new float[]{(float)target2.func_226277_ct_(), (float)target2.func_226278_cu_(), (float)target2.func_226281_cx_(), target2.field_70177_z, target2.field_70125_A};
            target2.func_70012_b(target1.func_226277_ct_(), target1.func_226278_cu_(), target1.func_226281_cx_(), target1.field_70177_z, target1.field_70125_A);
            target2.func_225653_b_(target1.func_226277_ct_(), target1.func_226278_cu_(), target1.func_226281_cx_());
            target1.func_70012_b((double)beforeCoords[0], (double)beforeCoords[1], (double)beforeCoords[2], beforeCoords[3], beforeCoords[4]);
            if (target1 instanceof OPEntity) {
                ((OPEntity)target1).func_195064_c(new EffectInstance((Effect)CartEffects.DISABLED_ABILITIES.get(), 60, 0));
                ((OPEntity)target1).func_195064_c(new EffectInstance((Effect)ModEffects.NO_HANDS.get(), 60, 0));
            }
            if (target2 instanceof OPEntity) {
                ((OPEntity)target1).func_195064_c(new EffectInstance((Effect)CartEffects.DISABLED_ABILITIES.get(), 60, 0));
                ((OPEntity)target1).func_195064_c(new EffectInstance((Effect)ModEffects.NO_HANDS.get(), 60, 0));
            }
            entity.field_70170_p.func_184133_a(null, target2.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 0.5f, 0.75f);
            entity.field_70170_p.func_184133_a(null, target1.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 0.5f, 0.75f);
        }
    }
}

