/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.oni;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SkullBasherAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"skull_basher", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user collides their skull with any target within range, applying bleeding.", null)});
    private static final float HOLD_TIME = 30.0f;
    private static final float CHARGE = 20.0f;
    private static final int MIN_COOLDOWN = 240;
    private static final int MAX_COOLDOWN = 300;
    private static final float RANGE = 2.0f;
    private static final float DAMAGE = 25.0f;
    public static final AbilityCore<SkullBasherAbility> INSTANCE = new AbilityCore.Builder("Skull Basher", AbilityCategory.RACIAL, SkullBasherAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)25.0f), ChargeComponent.getTooltip((float)20.0f), ContinuousComponent.getTooltip((float)30.0f), CooldownComponent.getTooltip((float)240.0f, (float)300.0f), RangeComponent.getTooltip((float)1.8f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceHakiNature(SourceHakiNature.HARDENING).setUnlockCheck(SkullBasherAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent((IAbility)this);
    private static final AbilityAttributeModifier STEP_HEIGHT_MODIFIER = new AbilityAttributeModifier(UUID.fromString("ecff1ac2-77c2-445e-b42d-be8428a775b0"), INSTANCE, "Skull Basher Step Height Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private Interval particleInterval = new Interval(2);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::tickChargeEvent).addEndEvent(this::endChargeEvent);

    public SkullBasherAbility(AbilityCore<SkullBasherAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.changeStatsComponent, this.continuousComponent, this.rangeComponent, this.dealDamageComponent, this.hitTrackerComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_HEIGHT_MODIFIER);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging() && !this.continuousComponent.isContinuous()) {
            this.chargeComponent.startCharging(entity, 20.0f);
        }
        if (this.continuousComponent.isContinuous()) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
    }

    private void tickChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.particleInterval.canTick()) {
            Vector3d look = entity.func_70040_Z().func_72432_b().func_186678_a(-2.5);
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.SKULL_BASHER.get()), (Entity)entity, (double)(entity.func_226277_ct_() + look.field_72450_a), (double)(entity.func_226278_cu_() + 2.0), (double)(entity.func_226281_cx_() + look.field_72449_c));
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 0, false, false));
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 30.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.changeStatsComponent.applyModifiers(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_70089_S()) {
            Vector3d look = entity.func_70040_Z();
            Vector3d speed = look.func_216372_d(1.35, 0.0, 1.35);
            entity.func_213315_a(MoverType.SELF, speed);
            List targets = this.rangeComponent.getTargetsInArea(entity, 1.8f);
            Iterator var = targets.iterator();
            Vector3d knockbackVec = speed.func_216372_d(1.25, 1.0, 1.25);
            while (var.hasNext()) {
                LivingEntity target = (LivingEntity)var.next();
                if (this.hitTrackerComponent.canHit((Entity)target)) {
                    this.dealDamageComponent.hurtTarget(entity, target, 25.0f);
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.BLEEDING.get(), 60, 0, false, false));
                    target.func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 1, false, false));
                }
                AbilityHelper.setDeltaMovement((Entity)target, (double)knockbackVec.field_72450_a, (double)0.2, (double)knockbackVec.field_72449_c);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 20, 0));
        this.changeStatsComponent.removeModifiers(entity);
        this.cooldownComponent.startCooldown(entity, 240.0f + this.continuousComponent.getContinueTime() * 2.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.ONI);
        return race && props.getDoriki() >= 2500.0;
    }
}

