/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.oni;

import net.MrMagicalCart.cartaddon.abilities.oni.OniHelper;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class PerceptionBlitzAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"perception_blitz", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user dashes forward with immense speed. (Decreased cooldown and increased dash range with \u00a7aOni Awakening\u00a7r)", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final float LONG_COOLDOWN = 140.0f;
    private static final float SHORT_COOLDOWN = 25.0f;
    public static final AbilityCore<PerceptionBlitzAbility> INSTANCE = new AbilityCore.Builder("Perception Blitz", AbilityCategory.RACIAL, PerceptionBlitzAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, StackComponent.getTooltip((int)2), AbilityHelper.createShortLongCooldownStat((float)25.0f, (float)180.0f)}).setUnlockCheck(PerceptionBlitzAbility::canUnlock).build();
    private final StackComponent stackComponent = new StackComponent((IAbility)this, 2).addStackChangeEvent(this::onStacksChange);

    public PerceptionBlitzAbility(AbilityCore<PerceptionBlitzAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.stackComponent});
        this.setOGCD();
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        Vector3d look = entity.func_70040_Z().func_216372_d(2.3, entity.func_70040_Z().field_72448_b >= 0.0 ? 0.0 : 0.6, 2.25);
        if (OniHelper.hasAwakeningActive(entity)) {
            look = entity.func_70040_Z().func_216372_d(2.5, entity.func_70040_Z().field_72448_b >= 0.0 ? 0.4 : 0.6, 2.5);
        }
        if (entity.field_191988_bg < 0.0f) {
            look = look.func_216372_d(-1.0, 1.0, -1.0);
        }
        if (entity.func_70090_H()) {
            look = look.func_216372_d(0.2, 0.2, 0.2);
        }
        AbilityHelper.setDeltaMovement((Entity)entity, (Vector3d)look);
        entity.func_195064_c(new EffectInstance(Effects.field_76424_c, 30, 3, false, false));
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.stackComponent.addStacks(entity, (IAbility)this, -1);
    }

    private void onStacksChange(LivingEntity entity, IAbility ability, int stacks) {
        if (stacks <= 0) {
            if (OniHelper.hasAwakeningActive(entity)) {
                this.cooldownComponent.startCooldown(entity, 160.0f);
            } else {
                this.cooldownComponent.startCooldown(entity, 180.0f);
            }
            this.stackComponent.revertStacksToDefault(entity, (IAbility)this);
        }
        this.cooldownComponent.startCooldown(entity, 25.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.ONI);
        return race && props.getDoriki() >= 1500.0;
    }
}

