/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.oni;

import java.util.UUID;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveStatBonusAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModResources;

public class OniPassiveBonusesAbility
extends PassiveStatBonusAbility {
    private static final AttributeModifier ONI_ARMOR = new AttributeModifier(UUID.fromString("39fa20d4-0c24-4654-8c0b-b35fd52c49c5"), "Oni Armor Bonus", 6.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier ONI_ARMOR_TOUGHNESS = new AttributeModifier(UUID.fromString("10d11ee3-a06b-410a-9c5d-3876095f46a2"), "Oni Armor Toughness Bonus", 4.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier ONI_DAMAGE = new AttributeModifier(UUID.fromString("0e52f678-4d40-46b9-b188-57c342fc8814"), "Oni Damage Bonus", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier ONI_HEALTH = new AttributeModifier(UUID.fromString("04dd9f0e-b519-4c16-b9a8-76a961b83cee"), "Oni Health Bonus", 20.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier ONI_SPEED = new AttributeModifier(UUID.fromString("442d1a32-8b43-4f9f-b9c3-80b70e606632"), "Oni Speed Bonus", 0.04, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier ONI_FALL = new AttributeModifier(UUID.fromString("48256447-75f3-4cc2-b094-0062c92382e9"), "Oni Fall Resistance Bonus", 3.0, AttributeModifier.Operation.ADDITION);
    private static final Predicate<LivingEntity> ONI_CHECK = entity -> {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.ONI);
        return race && props.getDoriki() >= 0.0;
    };
    public static final AbilityCore<OniPassiveBonusesAbility> INSTANCE = new AbilityCore.Builder("Oni Passive Bonuses", AbilityCategory.RACIAL, AbilityType.PASSIVE, OniPassiveBonusesAbility::new).setIcon(ModResources.PERK_ICON).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{ChangeStatsComponent.getTooltip()}).setUnlockCheck(OniPassiveBonusesAbility::canUnlock).build();

    public OniPassiveBonusesAbility(AbilityCore<OniPassiveBonusesAbility> core) {
        super(core);
        this.pushStaticAttribute(Attributes.field_233826_i_, ONI_ARMOR);
        this.pushStaticAttribute(Attributes.field_233827_j_, ONI_ARMOR_TOUGHNESS);
        this.pushStaticAttribute((Attribute)ModAttributes.PUNCH_DAMAGE.get(), ONI_DAMAGE);
        this.pushStaticAttribute(Attributes.field_233818_a_, ONI_HEALTH);
        this.pushStaticAttribute(Attributes.field_233821_d_, ONI_SPEED);
        this.pushStaticAttribute((Attribute)ModAttributes.FALL_RESISTANCE.get(), ONI_FALL);
    }

    public Predicate<LivingEntity> getCheck() {
        return ONI_CHECK;
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.ONI);
        return race && props.getDoriki() >= 0.0;
    }
}

