/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.oni;

import java.util.UUID;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.entities.mobs.quests.givers.BludgeonTrainerEntity;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class OniAwakeningAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"oni_awakening", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user unlocks their full potential, gaining stat buffs and immunity to fall damage. (Applies hunger and dizzy after use)", null)});
    private static final int HOLD_TIME = 600;
    private static final int MIN_COOLDOWN = 150;
    private static final int MAX_COOLDOWN = 750;
    public static final AbilityCore<OniAwakeningAbility> INSTANCE = new AbilityCore.Builder("Oni Awakening", AbilityCategory.RACIAL, OniAwakeningAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip((float)600.0f), CooldownComponent.getTooltip((float)150.0f, (float)750.0f), ChangeStatsComponent.getTooltip()}).setUnlockCheck(OniAwakeningAbility::canUnlock).build();
    private static final AbilityAttributeModifier MOVEMENT_MODIFIER = new AbilityAttributeModifier(UUID.fromString("759964a5-5347-4509-9beb-19271539224a"), INSTANCE, "Oni Awakening Movement Modifier", 0.06, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier JUMP_MODIFIER = new AbilityAttributeModifier(UUID.fromString("620815e8-ace3-4ec5-bf6f-8c89431c29fb"), INSTANCE, "Oni Awakening Jump Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ATTACK_MODIFIER = new AbilityAttributeModifier(UUID.fromString("3728e0ba-ec61-422c-9d76-0693e9b08107"), INSTANCE, "Oni Awakening Punch Damage Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent((IAbility)this);
    protected final DamageTakenComponent damageTakenComponent;

    public OniAwakeningAbility(AbilityCore<OniAwakeningAbility> core) {
        super(core);
        this.isNew = true;
        this.damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.changeStatsComponent, this.damageTakenComponent});
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)MOVEMENT_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.JUMP_HEIGHT, (AttributeModifier)JUMP_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)ATTACK_MODIFIER);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 600.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.applyModifiers(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.getContinueTime() % 2.0f == 0.0f && !entity.func_70644_a(Effects.field_76441_p) && !entity.func_70644_a((Effect)ModEffects.VANISH.get())) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.ONI_AWAKENING.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        }
        if (entity instanceof BludgeonTrainerEntity) {
            entity.func_195064_c(new EffectInstance(Effects.field_76428_l.getEffect(), 2, 1));
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.removeModifiers(entity);
        float cooldown = 150.0f + this.continuousComponent.getContinueTime();
        entity.func_195064_c(new EffectInstance(Effects.field_76438_s, 200, 0, false, false));
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 30, 0, false, false));
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (this.continuousComponent.isContinuous() && damageSource == DamageSource.field_76379_h) {
            return 0.0f;
        }
        return damage;
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.ONI);
        return race && props.getDoriki() >= 7500.0;
    }
}

