/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.nitoryu;

import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.entities.projectiles.nitoryu.NitoryuCounterStrikeProjectile;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NitoryuCounterStrikeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"nitoryu_counter_strike", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user blocks an incoming hit then damages the opponent if hit by a attack, otherwise if the target is more than 4 blocks away fires a air slash projectile.", null)});
    private static final float HOLD_TIME = 60.0f;
    private static final float MIN_COOLDOWN = 180.0f;
    public static final AbilityCore<NitoryuCounterStrikeAbility> INSTANCE = new AbilityCore.Builder("Nitoryu Counter Strike", AbilityCategory.STYLE, NitoryuCounterStrikeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)45.0f), ContinuousComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)180.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.SLASH}).setUnlockCheck(NitoryuCounterStrikeAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final PoolComponent poolComponent;
    private final DamageTakenComponent damageTakenComponent;
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);

    public NitoryuCounterStrikeAbility(AbilityCore<NitoryuCounterStrikeAbility> core) {
        super(core);
        this.poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.PARRY_COUNTER, new AbilityPool2[0]);
        this.damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTakenEvent, DamageTakenComponent.DamageState.ATTACK);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.dealDamageComponent, this.projectileComponent, this.continuousComponent, this.animationComponent, this.poolComponent, this.damageTakenComponent});
        this.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof PlayerEntity && !AbilityLimits.canUseNitoryu((LivingEntity)((PlayerEntity)entity)) || !AbilityHelper.canUseSwordsmanAbilities((LivingEntity)entity)) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You must be holding a sword in both hands to use this move!"), entity.func_110124_au());
            return;
        }
        this.continuousComponent.triggerContinuity(entity, 60.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.CROSSED_ARMS);
        if (entity instanceof PlayerEntity) {
            ItemStack stack = entity.func_184614_ca();
            stack.func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
            stack = entity.func_184592_cb();
            stack.func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.OFFHAND));
        }
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof PlayerEntity && !AbilityLimits.canUseNitoryu((LivingEntity)((PlayerEntity)entity)) || !AbilityHelper.canUseSwordsmanAbilities((LivingEntity)entity)) {
            this.continuousComponent.stopContinuity(entity);
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.GUARDING.get(), 2, 5, false, false));
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 180.0f);
    }

    private float onDamageTakenEvent(LivingEntity entity, IAbility ability, DamageSource source, float damage) {
        if (!this.continuousComponent.isContinuous()) {
            return damage;
        }
        Entity sourceEntity = source.func_76346_g();
        if (sourceEntity == null) {
            if (damage > 10.0f) {
                return damage / 2.0f;
            }
            return damage;
        }
        if (sourceEntity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)sourceEntity;
            if (target.func_70032_d((Entity)entity) > 4.0f) {
                this.projectileComponent.shoot(entity, 3.5f, 0.0f);
            } else if (target.func_70032_d((Entity)entity) <= 4.0f && this.dealDamageComponent.hurtTarget(entity, (LivingEntity)sourceEntity, 45.0f)) {
                Vector3d knockback = entity.func_213303_ch().func_178788_d(sourceEntity.func_213303_ch()).func_72432_b().func_186678_a(-1.0);
                AbilityHelper.setDeltaMovement((Entity)sourceEntity, (Vector3d)knockback);
                WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197603_N, (ServerWorld)((ServerWorld)entity.field_70170_p), (double)sourceEntity.func_226277_ct_(), (double)(sourceEntity.func_226278_cu_() + (double)sourceEntity.func_70047_e()), (double)sourceEntity.func_226281_cx_());
            }
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76429_m, 30, 3));
        this.continuousComponent.stopContinuity(entity);
        return 0.0f;
    }

    private NitoryuCounterStrikeProjectile createProjectile(LivingEntity entity) {
        NitoryuCounterStrikeProjectile proj = new NitoryuCounterStrikeProjectile(entity.field_70170_p, entity);
        return proj;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.NITORYU) && questProps.hasFinishedQuest(CartQuests.NITORYU_TRIAL_05);
    }
}

