/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.nitoryu;

import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.entities.projectiles.nitoryu.NanahyakunijuPoundHoProjectile;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class NanahyakunijuPoundHoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"nanahyakuniju_pound_ho", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user fires two air slashes at their opponent.", null)});
    private static final int COOLDOWN = 200;
    public static final AbilityCore<NanahyakunijuPoundHoAbility> INSTANCE = new AbilityCore.Builder("Nanahyakuniju Pound Ho", AbilityCategory.STYLE, NanahyakunijuPoundHoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)200.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.SLASH}).setSourceElement(SourceElement.AIR).setUnlockCheck(NanahyakunijuPoundHoAbility::canUnlock).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);

    public NanahyakunijuPoundHoAbility(AbilityCore<NanahyakunijuPoundHoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.animationComponent});
        this.addUseEvent(this::onUseEvent);
        this.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof PlayerEntity && !AbilityLimits.canUseNitoryu((LivingEntity)((PlayerEntity)entity)) || !AbilityHelper.canUseSwordsmanAbilities((LivingEntity)entity)) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You must be holding a sword in both hands to use this move!"), entity.func_110124_au());
            return;
        }
        this.animationComponent.start(entity, ModAnimations.RAISE_ARMS, 2);
        if (entity instanceof PlayerEntity) {
            ItemStack stack = entity.func_184614_ca();
            stack.func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
            stack = entity.func_184592_cb();
            stack.func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.OFFHAND));
        }
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        NanahyakunijuPoundHoProjectile proj = new NanahyakunijuPoundHoProjectile(entity.field_70170_p, entity);
        entity.field_70170_p.func_217376_c((Entity)proj);
        proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z - 3.0f, 0.0f, 2.0f, 0.75f);
        NanahyakunijuPoundHoProjectile proj2 = new NanahyakunijuPoundHoProjectile(entity.field_70170_p, entity);
        entity.field_70170_p.func_217376_c((Entity)proj2);
        proj2.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z + 3.0f, 0.0f, 2.0f, 0.75f);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private NanahyakunijuPoundHoProjectile createProjectile(LivingEntity entity) {
        NanahyakunijuPoundHoProjectile proj = new NanahyakunijuPoundHoProjectile(entity.field_70170_p, entity);
        return proj;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.NITORYU) && questProps.hasFinishedQuest(CartQuests.NITORYU_TRIAL_03);
    }
}

