/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.nitoryu;

import java.util.List;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartAnimations;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.DropHitAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MagumaAbility
extends DropHitAbility {
    private static final int COOLDOWN = 200;
    private static final float MIN_RANGE = 2.5f;
    private static final float MAX_RANGE = 7.0f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"maguma", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user leaps into the air, deals damage to those below them, applying dizzy and bleeding to those close to them.", null)});
    public static final AbilityCore<MagumaAbility> INSTANCE = new AbilityCore.Builder("Maguma", AbilityCategory.STYLE, MagumaAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)15.0f, (float)50.0f), RangeComponent.getTooltip((float)3.5f, (float)7.5f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE), CooldownComponent.getTooltip((float)200.0f)}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.SLASH}).setUnlockCheck(MagumaAbility::canUnlock).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);

    public MagumaAbility(AbilityCore<MagumaAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.animationComponent, this.dealDamageComponent, this.rangeComponent});
        this.continuousComponent.addStartEvent(this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(this::endContinuityEvent);
        this.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
    }

    public void onLanding(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            ItemStack stack = entity.func_184614_ca();
            stack.func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
            stack = entity.func_184592_cb();
            stack.func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.OFFHAND));
        }
        List targets = this.rangeComponent.getTargetsInArea(entity, 7.5f);
        List targets2 = this.rangeComponent.getTargetsInArea(entity, 3.5f);
        targets.remove(entity);
        targets2.remove(entity);
        AbilityDamageSource source = (AbilityDamageSource)ModDamageSource.causeAbilityDamage((LivingEntity)entity, (AbilityCore)this.getCore()).setSlash();
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !entity.func_70685_l((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 15.0f, (DamageSource)source)) continue;
            WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197603_N, (ServerWorld)((ServerWorld)entity.field_70170_p), (double)target.func_226277_ct_(), (double)(target.func_226278_cu_() + (double)target.func_70047_e()), (double)target.func_226281_cx_());
        }
        this.hitTrackerComponent.clearHits();
        for (LivingEntity target : targets2) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !entity.func_70685_l((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 35.0f, (DamageSource)source)) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.BLEEDING.get(), 60, 1, false, false));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 30, 1, false, false));
            WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197603_N, (ServerWorld)((ServerWorld)entity.field_70170_p), (double)target.func_226277_ct_(), (double)(target.func_226278_cu_() + (double)target.func_70047_e()), (double)target.func_226281_cx_());
            AbilityHelper.disableAbilities((LivingEntity)target, (int)100, abl -> abl.hasComponent(ModAbilityKeys.POOL) && ((PoolComponent)abl.getComponent(ModAbilityKeys.POOL).get()).containsPool(ModAbilityPools.TEKKAI_LIKE));
        }
        if (!entity.field_70170_p.field_72995_K && targets.size() > 0) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof PlayerEntity && !AbilityLimits.canUseNitoryu((LivingEntity)((PlayerEntity)entity)) || !AbilityHelper.canUseSwordsmanAbilities((LivingEntity)entity)) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You must be holding a sword in both hands to use this move!"), entity.func_110124_au());
            return;
        }
        this.animationComponent.start(entity, CartAnimations.MAGUMA);
        this.hitTrackerComponent.clearHits();
        Vector3d speed = WyHelper.propulsion((LivingEntity)entity, (double)1.0, (double)1.0);
        entity.func_213293_j(speed.field_72450_a, 1.25, speed.field_72449_c);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof PlayerEntity && !AbilityLimits.canUseNitoryu((LivingEntity)((PlayerEntity)entity)) || !AbilityHelper.canUseSwordsmanAbilities((LivingEntity)entity)) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.NITORYU) && questProps.hasFinishedQuest(CartQuests.NITORYU_TRIAL_02);
    }
}

