/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.nikyuextra;

import net.MrMagicalCart.cartaddon.entities.projectiles.nikyuextra.ReworkedUrsusShockProjectile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.nikyu.ChargingUrsusShockEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class ReworkedUrsusShockAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"ursus_shock", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user compresses air and sends it towards the opponent to create a huge shockwave", null)});
    private static final int COOLDOWN = 500;
    private static final int CHARGE_TIME = 140;
    public static final AbilityCore<ReworkedUrsusShockAbility> INSTANCE = new AbilityCore.Builder("Ursus Shock", AbilityCategory.DEVIL_FRUITS, ReworkedUrsusShockAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)42.5f, (float)85.0f), CooldownComponent.getTooltip((float)200.0f, (float)400.0f)}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.AIR).setSourceType(new SourceType[]{SourceType.PROJECTILE, SourceType.INTERNAL}).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, comp -> comp.getChargePercentage() >= 0.5f).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private ChargingUrsusShockEntity ursusShockEntity;

    public ReworkedUrsusShockAbility(AbilityCore<ReworkedUrsusShockAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.animationComponent, this.projectileComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 140.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.RAISE_ARMS, 140);
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.URSUS_SHOCK_SFX.get(), SoundCategory.PLAYERS, 5.0f, 0.75f);
        ChargingUrsusShockEntity chargingUrsusShock = new ChargingUrsusShockEntity(entity.field_70170_p);
        chargingUrsusShock.setOwner(entity);
        chargingUrsusShock.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + 2.0, entity.func_226281_cx_());
        entity.field_70170_p.func_217376_c((Entity)chargingUrsusShock);
        this.ursusShockEntity = chargingUrsusShock;
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.ursusShockEntity == null) {
            this.chargeComponent.forceStopCharging(entity);
        } else {
            boolean atThreshold = (double)this.chargeComponent.getChargePercentage() < 0.4;
            float currentCharge = this.ursusShockEntity.getCharge();
            currentCharge = (float)((double)currentCharge + (atThreshold ? 0.065 : -0.055));
            currentCharge = MathHelper.func_76131_a((float)currentCharge, (float)-1.4f, (float)10.0f);
            this.ursusShockEntity.setCharge(currentCharge);
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        float multiplier = this.chargeComponent.getChargePercentage();
        if (this.ursusShockEntity != null) {
            ReworkedUrsusShockProjectile projectile = new ReworkedUrsusShockProjectile(entity.field_70170_p, entity);
            projectile.multiplier = multiplier;
            projectile.setSize((double)multiplier > 0.75 ? 0.6f : 5.0f * (1.0f - multiplier));
            projectile.setChargedAmount(this.chargeComponent.getChargePercentage());
            entity.field_70170_p.func_217376_c((Entity)projectile);
            projectile.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 2.0f, 0.0f);
        }
        this.ursusShockEntity.func_70106_y();
        this.cooldownComponent.startCooldown(entity, 400.0f * multiplier);
    }

    private ReworkedUrsusShockProjectile createProjectile(LivingEntity entity) {
        ReworkedUrsusShockProjectile proj = new ReworkedUrsusShockProjectile(entity.field_70170_p, entity);
        return proj;
    }
}

