/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mori;

import net.MrMagicalCart.cartaddon.abilities.mori.MoriHelper;
import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.entities.projectiles.mori.MoriPillarEntity;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class RootEmergenceAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"root_emergence", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user creates a root beneath their crosshair, which applies bleeding and dehydration on hit. While in a forest or jungle the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"}), ImmutablePair.of((Object)"The user while in Kinniku Mori Mori, spawns roots beneath their crosshair, which applies bleeding and dehydration on hit. While in a forest or jungle the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final float COOLDOWN = 450.0f;
    public static final AbilityCore<RootEmergenceAbility> INSTANCE;
    private final AltModeComponent<Mode> altModeComponent;
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addTickEvent(this::onContinuityTick).addEndEvent(this::endContinuityEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private static final TranslationTextComponent MORI_EMERGENCE;
    private static final TranslationTextComponent ROOT_RAMPAGE;
    private static final ResourceLocation MORI_EMERGENCE_ICON;
    private static final ResourceLocation ROOT_RAMPAGE_ICON;

    public RootEmergenceAbility(AbilityCore<RootEmergenceAbility> core) {
        super(core);
        this.isNew = true;
        this.altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.EMERGENCE, true).addChangeModeEvent(this::onAltModeChange);
        this.addComponents(new AbilityComponent[]{this.projectileComponent, this.altModeComponent, this.continuousComponent});
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)64.0);
        if (this.altModeComponent.getCurrentMode() == Mode.EMERGENCE) {
            if (mop.func_216346_c() != RayTraceResult.Type.MISS) {
                double i = mop.func_216347_e().field_72450_a;
                double j = mop.func_216347_e().field_72448_b;
                double k = mop.func_216347_e().field_72449_c;
                MoriPillarEntity pillar = (MoriPillarEntity)this.projectileComponent.getNewProjectile(entity);
                pillar.func_70012_b(i, j - 6.0, k, 0.0f, 0.0f);
                pillar.func_70186_c(0.0, 0.001, 0.0, 1.5f, 0.0f);
                entity.field_70170_p.func_217376_c((Entity)pillar);
                this.cooldownComponent.getBonusManager().removeBonus(MoriHelper.FOREST_COOLDOWN_BONUS);
                if (MoriHelper.isFruitBoosted(entity)) {
                    this.cooldownComponent.getBonusManager().addBonus(MoriHelper.FOREST_COOLDOWN_BONUS, "Forest and Jungle Cooldown Bonus", BonusOperation.MUL, 0.8f);
                }
                this.cooldownComponent.startCooldown(entity, 450.0f);
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.ROOT_RAMPAGE) {
            this.continuousComponent.startContinuity(entity, 80.0f);
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        RayTraceResult mop;
        if (!MoriHelper.usingKinniku(entity)) {
            this.continuousComponent.stopContinuity(entity);
        }
        if ((mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)64.0)).func_216346_c() != RayTraceResult.Type.MISS) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.ROOT_RAMPAGE.get()), (Entity)entity, (double)mop.func_216347_e().field_72450_a, (double)mop.func_216347_e().field_72448_b, (double)mop.func_216347_e().field_72449_c);
            if (this.continuousComponent.getContinueTime() % 20.0f == 0.0f) {
                for (int a = 0; a < 13; ++a) {
                    double x = mop.func_216347_e().field_72450_a;
                    double y = mop.func_216347_e().field_72448_b;
                    double z = mop.func_216347_e().field_72449_c;
                    double i = x + WyHelper.randomDouble() * 10.0;
                    double j = y - WyHelper.randomDouble() * 4.0;
                    double k = z + WyHelper.randomDouble() * 10.0;
                    MoriPillarEntity pillar = (MoriPillarEntity)this.projectileComponent.getNewProjectile(entity);
                    pillar.func_70012_b(i, j - 6.0, k, 0.0f, 0.0f);
                    pillar.func_70186_c(0.0, 0.001, 0.0, 1.5f, 0.0f);
                    entity.field_70170_p.func_217376_c((Entity)pillar);
                }
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.getBonusManager().removeBonus(MoriHelper.FOREST_COOLDOWN_BONUS);
        if (MoriHelper.isFruitBoosted(entity)) {
            this.cooldownComponent.getBonusManager().addBonus(MoriHelper.FOREST_COOLDOWN_BONUS, "Forest and Jungle Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 600.0f);
    }

    private MoriPillarEntity createProjectile(LivingEntity entity) {
        MoriPillarEntity pillar = new MoriPillarEntity(entity.field_70170_p, entity);
        if (this.altModeComponent.getCurrentMode() == Mode.ROOT_RAMPAGE) {
            pillar.setDamage(pillar.getDamage() * 0.65f);
        }
        return pillar;
    }

    public void switchNormal(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.EMERGENCE);
    }

    public void switchKinniku(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.ROOT_RAMPAGE);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.EMERGENCE) {
            super.setDisplayName((ITextComponent)MORI_EMERGENCE);
            super.setDisplayIcon(MORI_EMERGENCE_ICON);
        } else if (mode == Mode.ROOT_RAMPAGE) {
            super.setDisplayName((ITextComponent)ROOT_RAMPAGE);
            super.setDisplayIcon(ROOT_RAMPAGE_ICON);
        }
    }

    static {
        MORI_EMERGENCE = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.root_emergence", "Root Emergence"));
        ROOT_RAMPAGE = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.root_rampage", "Root Rampage"));
        MORI_EMERGENCE_ICON = new ResourceLocation("cartaddon", "textures/abilities/root_emergence.png");
        ROOT_RAMPAGE_ICON = new ResourceLocation("cartaddon", "textures/abilities/root_rampage.png");
        INSTANCE = new AbilityCore.Builder("Root Emergence", AbilityCategory.DEVIL_FRUITS, RootEmergenceAbility::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> MORI_EMERGENCE.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], DealDamageComponent.getTooltip((float)15.0f), CooldownComponent.getTooltip((float)450.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> ROOT_RAMPAGE.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], DealDamageComponent.getTooltip((float)9.75f), CooldownComponent.getTooltip((float)600.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    }

    public static enum Mode {
        EMERGENCE,
        ROOT_RAMPAGE;

    }
}

