/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mori;

import net.MrMagicalCart.cartaddon.abilities.mori.MoriHelper;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.entities.projectiles.mori.KinnikuGatlingProjectile;
import net.MrMagicalCart.cartaddon.entities.projectiles.mori.PiercingBlowsProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.RepeaterAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;

public class PiercingBlowsAbility
extends RepeaterAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"piercing_blows", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user launches a barrage of piercing branches. While in a forest or jungle the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"}), ImmutablePair.of((Object)"The user launches a barrage of large punches while in Kinniku Mori Mori. While in a forest or jungle the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final TranslationTextComponent PIERCING_BLOWS = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.piercing_blows", "Piercing Blows"));
    private static final TranslationTextComponent KINNIKU_GATLING = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.kinniku_gatling", "Kinniku Gatling"));
    private static final ResourceLocation PIERCING_BLOWS_ICON = new ResourceLocation("cartaddon", "textures/abilities/piercing_blows.png");
    private static final ResourceLocation KINNIKU_GATLING_ICON = new ResourceLocation("cartaddon", "textures/abilities/kinniku_gatling.png");
    private static final int PIERCING_BLOWS_COOLDOWN = 400;
    private static final int PIERCING_BLOWS_TRIGGERS = 15;
    private static final int PIERCING_BLOWS_INTERVAL = 3;
    private static final int KINNIKU_GATLING_COOLDOWN = 900;
    private static final int KINNIKU_GATLING_TRIGGERS = 10;
    private static final int KINNIKU_GATLING_INTERVAL = 7;
    public static final AbilityCore<PiercingBlowsAbility> INSTANCE = new AbilityCore.Builder("Piercing Blows", AbilityCategory.DEVIL_FRUITS, PiercingBlowsAbility::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> PIERCING_BLOWS.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], CooldownComponent.getTooltip((float)400.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> KINNIKU_GATLING.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], CooldownComponent.getTooltip((float)900.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.PIERCING_BLOWS, true).addChangeModeEvent(this::onAltModeChange);
    private float projectileSpeed;
    private int projectileSpread;
    private float cooldown = 600.0f;
    private int triggers = 15;
    private int interval = 2;

    public PiercingBlowsAbility(AbilityCore<PiercingBlowsAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.altModeComponent});
        this.setCustomShootLogic(living -> {
            for (int i = 0; i < 5; ++i) {
                this.projectileComponent.shootWithSpread(living, this.projectileSpeed, 3.0f, this.projectileSpread);
            }
        });
        this.repeaterComponent.addTriggerEvent(100, this::triggerRepeaterEvent);
        this.continuousComponent.addTickEvent(this::tickContinuityEvent).addEndEvent(100, this::endContinuityEvent);
        this.addCanUseCheck(AbilityLimits::usingBrawler);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (AbilityLimits.cancelBrawler(entity)) {
            if (this.altModeComponent.getCurrentMode() == Mode.PIERCING_BLOWS) {
                this.cooldownComponent.startCooldown(entity, 400.0f);
            } else {
                this.cooldownComponent.startCooldown(entity, 900.0f);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.PIERCING_BLOWS) {
            this.cooldownComponent.getBonusManager().removeBonus(MoriHelper.FOREST_COOLDOWN_BONUS);
            if (MoriHelper.isFruitBoosted(entity)) {
                this.cooldownComponent.getBonusManager().addBonus(MoriHelper.FOREST_COOLDOWN_BONUS, "Forest and Jungle Cooldown Bonus", BonusOperation.MUL, 0.8f);
            }
            this.cooldownComponent.startCooldown(entity, 400.0f);
        } else {
            this.cooldownComponent.getBonusManager().removeBonus(MoriHelper.FOREST_COOLDOWN_BONUS);
            if (MoriHelper.isFruitBoosted(entity)) {
                this.cooldownComponent.getBonusManager().addBonus(MoriHelper.FOREST_COOLDOWN_BONUS, "Forest and Jungle Cooldown Bonus", BonusOperation.MUL, 0.8f);
            }
            this.cooldownComponent.startCooldown(entity, 900.0f);
        }
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        entity.func_226292_a_(Hand.MAIN_HAND, true);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.KINNIKI_GATLING) {
            super.setDisplayName((ITextComponent)KINNIKU_GATLING);
            super.setDisplayIcon(KINNIKU_GATLING_ICON);
            this.triggers = 10;
            this.interval = 7;
        } else if (mode == Mode.PIERCING_BLOWS) {
            super.setDisplayName((ITextComponent)PIERCING_BLOWS);
            super.setDisplayIcon(PIERCING_BLOWS_ICON);
            this.triggers = 15;
            this.interval = 3;
        }
    }

    public int getMaxTriggers() {
        return this.triggers;
    }

    public int getTriggerInterval() {
        return this.interval;
    }

    public float getRepeaterCooldown() {
        return this.cooldown;
    }

    public AbilityProjectileEntity getProjectileFactory(LivingEntity entity) {
        AbilityProjectileEntity projectile = null;
        float projDmageReduction = 0.7f;
        if (this.altModeComponent.getCurrentMode() == Mode.KINNIKI_GATLING) {
            projectile = new KinnikuGatlingProjectile(entity.field_70170_p, entity, (Ability)this);
            projectile.setEntityCollisionSize(2.5);
            this.projectileSpeed = 2.2f;
            this.projectileSpread = 6;
            projDmageReduction = 0.6f;
        } else {
            projectile = new PiercingBlowsProjectile(entity.field_70170_p, entity, (Ability)this);
            projectile.setEntityCollisionSize(1.25);
            this.projectileSpread = 2;
            this.projectileSpeed = 2.5f;
        }
        projectile.setDamage(projectile.getDamage() * (1.0f - projDmageReduction));
        projectile.setMaxLife((int)((double)projectile.getMaxLife() * 0.75));
        return projectile;
    }

    public void switchNormal(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.PIERCING_BLOWS);
    }

    public void switchKinniku(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)Mode.KINNIKI_GATLING);
    }

    public static enum Mode {
        PIERCING_BLOWS,
        KINNIKI_GATLING;

    }
}

