/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mori;

import net.MrMagicalCart.cartaddon.abilities.mori.MoriHelper;
import net.MrMagicalCart.cartaddon.entities.projectiles.mori.MoriSkewerProjectile;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MoriSkewerAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"mori_skewer", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user launches a wooden spike that applies bleeding, dehydration, and stun on enemies it hits.", null), ImmutablePair.of((Object)"While in a forest or jungle the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final float CHARGE_TIME = 30.0f;
    private static final float COOLDOWN = 400.0f;
    public static final AbilityCore<MoriSkewerAbility> INSTANCE = new AbilityCore.Builder("Mori Skewer", AbilityCategory.DEVIL_FRUITS, MoriSkewerAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChargeComponent.getTooltip((float)40.0f), CooldownComponent.getTooltip((float)400.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(100, this::startChargingEvent).addTickEvent(100, this::tickChargingEvent).addEndEvent(100, this::endChargingEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);

    public MoriSkewerAbility(AbilityCore<MoriSkewerAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.projectileComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            this.chargeComponent.startCharging(entity, 40.0f);
        }
    }

    private void startChargingEvent(LivingEntity entity, IAbility ability) {
    }

    private void tickChargingEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.getChargeTime() % 8.0f == 0.0f) {
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), SoundEvents.field_187571_bR, SoundCategory.PLAYERS, 2.0f, 1.0f);
        }
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.CHARGE_MORI_SKEWER.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
    }

    private void endChargingEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 2.75f, 0.5f);
        this.cooldownComponent.getBonusManager().removeBonus(MoriHelper.FOREST_COOLDOWN_BONUS);
        if (MoriHelper.isFruitBoosted(entity)) {
            this.cooldownComponent.getBonusManager().addBonus(MoriHelper.FOREST_COOLDOWN_BONUS, "Forest and Jungle Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    private MoriSkewerProjectile createProjectile(LivingEntity entity) {
        MoriSkewerProjectile proj = new MoriSkewerProjectile(entity.field_70170_p, entity);
        return proj;
    }
}

