/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mori;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.mori.MoriHelper;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.BambooSaplingBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.blocks.TangerineCropsBlock;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MoriGrowthAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"mori_growth", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user increases their regeneration rate and growth speed of the plants around them. (10 blocks in each direction, or a 21x21 area)", null), ImmutablePair.of((Object)"While in a forest or jungle the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final float COOLDOWN = 900.0f;
    private static final float HOLD_TIME = 60.0f;
    public static final AbilityCore<MoriGrowthAbility> INSTANCE = new AbilityCore.Builder("Mori Growth", AbilityCategory.DEVIL_FRUITS, MoriGrowthAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)900.0f), ChangeStatsComponent.getTooltip()}).build();
    private static final AbilityAttributeModifier REGEN_RATE_MODIFIER = new AbilityAttributeModifier(UUID.fromString("eb792d0d-c1a9-4e34-8f64-b9a5726a1bdf"), INSTANCE, "Mori Growth Regeneration Rate Modifier", 2.0, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent((IAbility)this);
    public static final float RANGE = 10.0f;

    public MoriGrowthAbility(AbilityCore core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.changeStatsComponent});
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.REGEN_RATE, (AttributeModifier)REGEN_RATE_MODIFIER);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility abiltiy) {
        this.continuousComponent.triggerContinuity(entity, 60.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.applyModifiers(entity);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), SoundEvents.field_206938_K, SoundCategory.PLAYERS, 10.0f, 1.0f);
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.MORI_GROWTH.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        List targets = WyHelper.getNearbyBlocks((BlockPos)entity.func_233580_cy_(), (IWorld)entity.field_70170_p, (int)10);
        targets.removeIf(block -> !(entity.field_70170_p.func_180495_p(block).func_177230_c() instanceof CropsBlock) && !(entity.field_70170_p.func_180495_p(block).func_177230_c() instanceof SaplingBlock) && !(entity.field_70170_p.func_180495_p(block).func_177230_c() instanceof StemBlock) && !(entity.field_70170_p.func_180495_p(block).func_177230_c() instanceof SugarCaneBlock) && !(entity.field_70170_p.func_180495_p(block).func_177230_c() instanceof CactusBlock) && !(entity.field_70170_p.func_180495_p(block).func_177230_c() instanceof TangerineCropsBlock) && !(entity.field_70170_p.func_180495_p(block).func_177230_c() instanceof BambooBlock) && !(entity.field_70170_p.func_180495_p(block).func_177230_c() instanceof BambooSaplingBlock));
        for (BlockPos blockPos : targets) {
            BlockState blockState = entity.field_70170_p.func_180495_p(blockPos);
            if (entity.field_70170_p.func_180495_p(blockPos).func_177230_c() instanceof CropsBlock) {
                CropsBlock cropsBlock = (CropsBlock)blockState.func_177230_c();
                cropsBlock.func_225542_b_(blockState, (ServerWorld)entity.field_70170_p, blockPos, new Random());
                continue;
            }
            if (entity.field_70170_p.func_180495_p(blockPos).func_177230_c() instanceof SaplingBlock) {
                SaplingBlock saplingBlock = (SaplingBlock)blockState.func_177230_c();
                saplingBlock.func_225542_b_(blockState, (ServerWorld)entity.field_70170_p, blockPos, new Random());
                continue;
            }
            if (entity.field_70170_p.func_180495_p(blockPos).func_177230_c() instanceof StemBlock) {
                StemBlock stemBlock = (StemBlock)blockState.func_177230_c();
                stemBlock.func_225542_b_(blockState, (ServerWorld)entity.field_70170_p, blockPos, new Random());
                continue;
            }
            if (entity.field_70170_p.func_180495_p(blockPos).func_177230_c() instanceof SugarCaneBlock) {
                SugarCaneBlock sugarCaneBlock = (SugarCaneBlock)blockState.func_177230_c();
                sugarCaneBlock.func_225542_b_(blockState, (ServerWorld)entity.field_70170_p, blockPos, new Random());
                continue;
            }
            if (entity.field_70170_p.func_180495_p(blockPos).func_177230_c() instanceof CactusBlock) {
                CactusBlock cactusBlock = (CactusBlock)blockState.func_177230_c();
                cactusBlock.func_225542_b_(blockState, (ServerWorld)entity.field_70170_p, blockPos, new Random());
                continue;
            }
            if (entity.field_70170_p.func_180495_p(blockPos).func_177230_c() instanceof TangerineCropsBlock) {
                TangerineCropsBlock tangerineCropsBlock = (TangerineCropsBlock)blockState.func_177230_c();
                tangerineCropsBlock.func_225542_b_(blockState, (ServerWorld)entity.field_70170_p, blockPos, new Random());
                continue;
            }
            if (entity.field_70170_p.func_180495_p(blockPos).func_177230_c() instanceof BambooBlock) {
                BambooBlock bambooBlock = (BambooBlock)blockState.func_177230_c();
                bambooBlock.func_225542_b_(blockState, (ServerWorld)entity.field_70170_p, blockPos, new Random());
                continue;
            }
            if (!(entity.field_70170_p.func_180495_p(blockPos).func_177230_c() instanceof BambooSaplingBlock)) continue;
            BambooSaplingBlock bambooSaplingBlock = (BambooSaplingBlock)blockState.func_177230_c();
            bambooSaplingBlock.func_225542_b_(blockState, (ServerWorld)entity.field_70170_p, blockPos, new Random());
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.removeModifiers(entity);
        this.cooldownComponent.getBonusManager().removeBonus(MoriHelper.FOREST_COOLDOWN_BONUS);
        if (MoriHelper.isFruitBoosted(entity)) {
            this.cooldownComponent.getBonusManager().addBonus(MoriHelper.FOREST_COOLDOWN_BONUS, "Forest and Jungle Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 900.0f);
    }
}

