/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mori;

import net.MrMagicalCart.cartaddon.abilities.mori.KinnikuMoriMoriAbility;
import net.MrMagicalCart.cartaddon.abilities.mori.MoriArmAbility;
import net.MrMagicalCart.cartaddon.abilities.mori.MoriFlightPassiveAbility;
import net.MrMagicalCart.cartaddon.abilities.mori.MoriHelper;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class MoriFlyAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"mori_fly", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user creates a flower that allows them to fly. (Can't activate with Mori Arm or Kinniku Mori Mori)", null), ImmutablePair.of((Object)"While in a forest or jungle the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final int COOLDOWN = 200;
    public static final AbilityCore<MoriFlyAbility> INSTANCE = new AbilityCore.Builder("Mori Fly", AbilityCategory.DEVIL_FRUITS, MoriFlyAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)200.0f)}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    TranslationTextComponent text;

    public MoriFlyAbility(AbilityCore<MoriFlyAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.morphComponent});
        this.addCanUseCheck((entity, ability) -> {
            this.text = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_TOGETHER, new Object[]{this.getDisplayName().getString(), KinnikuMoriMoriAbility.INSTANCE.getUnlocalizedName()});
            return ((MorphInfo)CartMorphs.KINNIKU_MORI_MORI.get()).isActive(entity) ? AbilityUseResult.fail((ITextComponent)this.text) : AbilityUseResult.success();
        });
        this.addCanUseCheck((entity, ability) -> {
            this.text = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_TOGETHER, new Object[]{this.getDisplayName().getString(), MoriArmAbility.INSTANCE.getUnlocalizedName()});
            return ((MorphInfo)CartMorphs.MORI_ARM.get()).isActive(entity) ? AbilityUseResult.fail((ITextComponent)this.text) : AbilityUseResult.success();
        });
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            this.continuousComponent.triggerContinuity(entity);
        } else {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        PropelledFlightAbility moriFlightAbility;
        IAbilityData abilityDataProps;
        this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.MORI_FLY.get());
        if (!entity.field_70170_p.field_72995_K && (abilityDataProps = AbilityDataCapability.get((LivingEntity)entity)) != null && (moriFlightAbility = (PropelledFlightAbility)abilityDataProps.getPassiveAbility(MoriFlightPassiveAbility.INSTANCE)) != null && !moriFlightAbility.isPaused()) {
            PropelledFlightAbility.enableFlight((PlayerEntity)((PlayerEntity)entity));
        }
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        PropelledFlightAbility moriFlightAbility;
        IAbilityData abilityDataProps;
        if (!entity.field_70170_p.field_72995_K && (abilityDataProps = AbilityDataCapability.get((LivingEntity)entity)) != null && (moriFlightAbility = (PropelledFlightAbility)abilityDataProps.getPassiveAbility(MoriFlightPassiveAbility.INSTANCE)) != null) {
            PropelledFlightAbility.disableFlight((PlayerEntity)((PlayerEntity)entity));
        }
        this.morphComponent.stopMorph(entity);
        this.cooldownComponent.getBonusManager().removeBonus(MoriHelper.FOREST_COOLDOWN_BONUS);
        if (MoriHelper.isFruitBoosted(entity)) {
            this.cooldownComponent.getBonusManager().addBonus(MoriHelper.FOREST_COOLDOWN_BONUS, "Forest and Jungle Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

