/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mori;

import net.MrMagicalCart.cartaddon.abilities.mori.BokarinAbility;
import net.MrMagicalCart.cartaddon.abilities.mori.KinnikuMoriMoriAbility;
import net.MrMagicalCart.cartaddon.abilities.mori.MoriLogiaAbility;
import net.MrMagicalCart.cartaddon.init.CartEffects;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;

public class MoriFireWeakness
extends PassiveAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"mori_fire_weakness", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user takes extra damage from fire sources.", null)});
    private final Interval damageInterval = new Interval(10);
    public static final AbilityCore<MoriLogiaAbility> INSTANCE = new AbilityCore.Builder("Mori Fire Weakness", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, MoriFireWeakness::new).addDescriptionLine(DESCRIPTION).setHidden().build();

    public MoriFireWeakness(AbilityCore core) {
        super(core);
        this.addDuringPassiveEvent(this::duringPassiveEvent);
    }

    public void duringPassiveEvent(LivingEntity entity) {
        if (entity.func_70027_ad() || entity.func_180799_ab()) {
            entity.func_195064_c(new EffectInstance((Effect)CartEffects.BURNT.get(), 600, 0, true, false));
        }
        if (!entity.func_70089_S() || entity.func_70644_a(Effects.field_76426_n)) {
            return;
        }
        if ((entity.func_70027_ad() || entity.func_180799_ab()) && entity.func_110143_aJ() > 50.0f) {
            float dmg = 1.0f;
            double doriki = 0.0;
            IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)entity);
            if (!MoriFireWeakness.hasBokarinAbilityActive(abilityDataProps) && this.damageInterval.canTick()) {
                doriki = EntityStatsCapability.get((LivingEntity)entity).getDoriki();
                dmg = (double)(dmg - (float)doriki / 1000.0f) < 0.2 ? 0.2f : (dmg -= (float)doriki / 1000.0f);
                if (!MoriFireWeakness.hasKinnikuAbilityActive(abilityDataProps)) {
                    entity.func_70606_j(entity.func_110143_aJ() - dmg);
                } else {
                    entity.func_70606_j(entity.func_110143_aJ() - dmg / 2.0f);
                }
            }
        }
    }

    public static boolean hasBokarinAbilityActive(IAbilityData props) {
        Ability ability = (Ability)props.getEquippedAbility(BokarinAbility.INSTANCE);
        boolean isActive = ability != null && ability.isContinuous();
        return isActive;
    }

    public static boolean hasKinnikuAbilityActive(IAbilityData props) {
        Ability ability = (Ability)props.getEquippedAbility(KinnikuMoriMoriAbility.INSTANCE);
        boolean isActive = ability != null && ability.isContinuous();
        return isActive;
    }
}

