/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mori;

import net.MrMagicalCart.cartaddon.abilities.mori.MoriHelper;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.cartapi.CartRegistry;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MoriDrainNewAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"mori_drain", (Pair[])new Pair[]{ImmutablePair.of((Object)"Quickly drains the enemy in front of the user of their moisture, leaving them weak for a few seconds. While in a forest or jungle the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"}), ImmutablePair.of((Object)"The user drains water from rivers, oceans, and grass type blocks nearby. While in a forest or jungle the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final int DRAIN_COOLDOWN = 400;
    private static final int DRAIN_CHARGE_TIME = 50;
    private static final int DRAIN_PULL_TIME = 200;
    private static final float DRAIN_DAMAGE = 15.0f;
    private static final int DEHYDRATE_COOLDOWN = 240;
    private static final int DEHYDRATE_HOLD_TIME = 180;
    private static final TranslationTextComponent MORI_DRAIN = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.mori_drain", "Mori Drain"));
    private static final TranslationTextComponent MORI_DEHYDRATE = new TranslationTextComponent(CartRegistry.registerName("ability.cartaddon.mori_dehydrate", "Mori Dehydrate"));
    private static final ResourceLocation MORI_DRAIN_ICON = new ResourceLocation("cartaddon", "textures/abilities/mori_drain.png");
    private static final ResourceLocation MORI_DEHYDRATE_ICON = new ResourceLocation("cartaddon", "textures/abilities/mori_dehydrate.png");
    public static final AbilityCore<MoriDrainNewAbility> INSTANCE = new AbilityCore.Builder("Mori Drain", AbilityCategory.DEVIL_FRUITS, MoriDrainNewAbility::new).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{(e, a) -> MORI_DRAIN.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], DealDamageComponent.getTooltip((float)25.0f), ChargeComponent.getTooltip((float)50.0f), CooldownComponent.getTooltip((float)400.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> MORI_DEHYDRATE.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], ContinuousComponent.getTooltip((float)180.0f), CooldownComponent.getTooltip((float)240.0f)}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, false).addTickEvent(this::duringContinuityEvent).addEndEvent(this::onContinuityEnd);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(100, this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final GrabEntityComponent grabComponent = new GrabEntityComponent((IAbility)this, true, true, true, 2.0f).addPullStartEvent(this::onPullStart).addPullEndEvent(this::onPullEnd);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addOnHitEvent(this::onHitEvent);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);
    private final Interval particleInterval = new Interval(6);
    private final AltModeComponent<Mode> altModeComponent;
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(new BlockProtectionRule[]{LiquidBlockProtectionRule.INSTANCE}).addBannedBlocks(new Block[]{Blocks.field_150353_l}).addReplaceRules((world, pos, state) -> {
        if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
            return true;
        }
        if (state.func_185904_a() != Material.field_151577_b && state.func_185904_a() != Material.field_151578_c && state.func_177230_c() != Blocks.field_203214_jx && state.func_177230_c() != Blocks.field_203198_aQ && state.func_177230_c() != Blocks.field_203199_aR) {
            return false;
        }
        world.func_175656_a(pos, Blocks.field_196660_k.func_176223_P());
        return true;
    }).build();

    public MoriDrainNewAbility(AbilityCore<MoriDrainNewAbility> core) {
        super(core);
        this.isNew = true;
        this.altModeComponent = new AltModeComponent((IAbility)this, Mode.class, (Enum)Mode.DRAIN).addChangeModeEvent(this::onAltModeChange);
        if (this.altModeComponent.getCurrentMode() == Mode.DRAIN) {
            super.setDisplayName((ITextComponent)MORI_DRAIN);
            super.setDisplayIcon(MORI_DRAIN_ICON);
        } else if (this.altModeComponent.getCurrentMode() == Mode.DEHYDRATE) {
            super.setDisplayName((ITextComponent)MORI_DEHYDRATE);
            super.setDisplayIcon(MORI_DEHYDRATE_ICON);
        }
        super.addComponents(new AbilityComponent[]{this.altModeComponent, this.dealDamageComponent, this.chargeComponent, this.animationComponent, this.continuousComponent, this.grabComponent, this.hitTriggerComponent, this.poolComponent});
        super.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.DRAIN) {
            if (!this.chargeComponent.isCharging()) {
                if (this.continuousComponent.isContinuous()) {
                    this.grabComponent.release(entity);
                    this.continuousComponent.stopContinuity(entity);
                } else if (this.grabComponent.getState() == GrabEntityComponent.GrabState.IDLE && this.grabComponent.grabNearest(entity, 4.5f, 2.0f, false)) {
                    this.grabComponent.triggerPulling(entity);
                } else {
                    this.cooldownComponent.startCooldown(entity, 15.0f);
                }
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.DEHYDRATE) {
            if (!this.continuousComponent.isContinuous()) {
                this.continuousComponent.startContinuity(entity, 180.0f);
            } else {
                this.continuousComponent.stopContinuity(entity);
            }
        }
    }

    private boolean onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.DRAIN) {
            if (this.continuousComponent.isContinuous() && !this.grabComponent.hasGrabbedEntity()) {
                if (this.grabComponent.grabManually(entity, target)) {
                    this.grabComponent.startPulling(entity);
                }
                target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 1));
                return false;
            }
            return true;
        }
        return true;
    }

    public void onPullStart(LivingEntity entity, IAbility ability) {
        this.continuousComponent.setThresholdTime(entity, 200.0f);
    }

    public void onPullEnd(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        if (this.grabComponent.canContinueGrab(entity)) {
            this.chargeComponent.startCharging(entity, 50.0f);
        }
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.DEHYDRATE) {
            AbilityHelper.createFilledSphere((World)entity.field_70170_p, (int)((int)entity.func_226277_ct_()), (int)((int)entity.func_226278_cu_()), (int)((int)entity.func_226281_cx_()), (int)9, (Block)Blocks.field_150350_a, (BlockProtectionRule)GRIEF_RULE);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (this.altModeComponent.getCurrentMode() == Mode.DRAIN) {
                if (this.grabComponent.getState() != GrabEntityComponent.GrabState.GRABBED) {
                    this.grabComponent.release(entity);
                }
                if (!this.grabComponent.canContinueGrab(entity)) {
                    this.cooldownComponent.getBonusManager().removeBonus(MoriHelper.FOREST_COOLDOWN_BONUS);
                    if (MoriHelper.isFruitBoosted(entity)) {
                        this.cooldownComponent.getBonusManager().addBonus(MoriHelper.FOREST_COOLDOWN_BONUS, "Forest and Jungle Cooldown Bonus", BonusOperation.MUL, 0.8f);
                    }
                    this.cooldownComponent.startCooldown(entity, 400.0f);
                }
            } else if (this.altModeComponent.getCurrentMode() == Mode.DEHYDRATE) {
                this.cooldownComponent.getBonusManager().removeBonus(MoriHelper.FOREST_COOLDOWN_BONUS);
                if (MoriHelper.isFruitBoosted(entity)) {
                    this.cooldownComponent.getBonusManager().addBonus(MoriHelper.FOREST_COOLDOWN_BONUS, "Forest and Jungle Cooldown Bonus", BonusOperation.MUL, 0.8f);
                }
                this.cooldownComponent.startCooldown(entity, 240.0f);
            }
        }
    }

    public void onChargeStart(LivingEntity entity, IAbility ability) {
        MoriHelper.drainLiquids(this.grabComponent.getGrabbedEntity(), (int)WyHelper.randomWithRange((int)0, (int)1), (int)WyHelper.randomWithRange((int)1, (int)3), (int)WyHelper.randomWithRange((int)0, (int)1));
        this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM);
        this.particleInterval.restartIntervalToZero();
    }

    public void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (AbilityLimits.cancelPartyTable(entity) || AbilityLimits.cancelOtatsumaki(entity) || AbilityLimits.cancelWhirlingMace(entity) || AbilityLimits.cancelSaiKuru(entity) || AbilityLimits.cancelVicousRoar(entity)) {
                this.chargeComponent.stopCharging(entity);
            }
            if (!super.canUse(entity).isFail() && this.grabComponent.canContinueGrab(entity)) {
                LivingEntity target = this.grabComponent.getGrabbedEntity();
                if (this.particleInterval.canTick()) {
                    WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.MORI_DRAIN.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)target.func_226278_cu_(), (double)target.func_226281_cx_());
                }
                DamageSource source = ModDamageSource.causeAbilityDamage((LivingEntity)entity, (IAbility)this).setInternal().func_151518_m();
                if (this.chargeComponent.getChargeTime() % 10.0f == 0.0f) {
                    this.dealDamageComponent.hurtTarget(entity, target, 1.0f, source);
                }
            } else {
                this.chargeComponent.stopCharging(entity);
            }
        }
    }

    public void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (this.grabComponent.hasGrabbedEntity()) {
            DamageSource source;
            LivingEntity target = this.grabComponent.getGrabbedEntity();
            if (this.dealDamageComponent.hurtTarget(entity, target, 25.0f, source = ModDamageSource.causeAbilityDamage((LivingEntity)entity, (IAbility)this).setInternal().func_151518_m())) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DEHYDRATION.get(), 300, 2, false, true));
                target.func_195064_c(new EffectInstance(Effects.field_76437_t, 300, 1, false, false));
                target.func_195064_c(new EffectInstance(Effects.field_76421_d, 300, 1, false, false));
                target.func_195064_c(new EffectInstance(Effects.field_76419_f, 300, 1, false, false));
            }
            this.grabComponent.release(entity);
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.getBonusManager().removeBonus(MoriHelper.FOREST_COOLDOWN_BONUS);
        if (MoriHelper.isFruitBoosted(entity)) {
            this.cooldownComponent.getBonusManager().addBonus(MoriHelper.FOREST_COOLDOWN_BONUS, "Forest Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (!this.chargeComponent.isCharging() && !this.continuousComponent.isContinuous()) {
            if (mode == Mode.DRAIN) {
                super.setDisplayName((ITextComponent)MORI_DRAIN);
                super.setDisplayIcon(MORI_DRAIN_ICON);
            } else if (mode == Mode.DEHYDRATE) {
                super.setDisplayName((ITextComponent)MORI_DEHYDRATE);
                super.setDisplayIcon(MORI_DEHYDRATE_ICON);
            }
        }
    }

    public static enum Mode {
        DRAIN,
        DEHYDRATE;

    }
}

