/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mori;

import java.util.UUID;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.mori.KinnikuMoriMoriAbility;
import net.MrMagicalCart.cartaddon.abilities.mori.MoriFlyAbility;
import net.MrMagicalCart.cartaddon.abilities.mori.MoriHelper;
import net.MrMagicalCart.cartaddon.init.CartEffects;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class MoriArmAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"mori_arm", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user creates a wooden arm to bash enemies with. This increases reach and power slightly. Has 12% chance to apply Overgrowth on enemies hit. (Can't activate alongside Mori Fly or Kinniku Mori Mori)", null), ImmutablePair.of((Object)"While in a forest the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final int HOLD_TIME = 600;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 600;
    public static final AbilityCore<MoriArmAbility> INSTANCE = new AbilityCore.Builder("Mori Arm", AbilityCategory.DEVIL_FRUITS, MoriArmAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)100.0f, (float)600.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{ChangeStatsComponent.getTooltip()}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).build();
    private static final AbilityAttributeModifier PUNCH_DAMAGE_MODIFIER = new AbilityAttributeModifier(UUID.fromString("0da7142a-6459-495d-9999-760a76c67aa3"), INSTANCE, "Mori Arm Strength Modifier", 8.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier REACH_MODIFIER = new AbilityAttributeModifier(UUID.fromString("cbc0339b-2b0d-4bd4-bc2d-e65be6ef00c8"), INSTANCE, "Mori Arm Reach Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ATTACK_SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("35f31857-b2cc-4529-8988-3fab6407b223"), INSTANCE, "Mori Arm Attack Speed Modifier", 0.5, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addOnHitEvent(this::hitEvent);
    private final ChangeStatsComponent statsComponent = new ChangeStatsComponent((IAbility)this);
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);
    TranslationTextComponent text;

    public MoriArmAbility(AbilityCore<MoriArmAbility> core) {
        super(core);
        this.addCanUseCheck((entity, ability) -> {
            this.text = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_TOGETHER, new Object[]{this.getDisplayName().getString(), KinnikuMoriMoriAbility.INSTANCE.getUnlocalizedName()});
            return ((MorphInfo)CartMorphs.KINNIKU_MORI_MORI.get()).isActive(entity) ? AbilityUseResult.fail((ITextComponent)this.text) : AbilityUseResult.success();
        });
        this.addCanUseCheck((entity, ability) -> {
            this.text = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_TOGETHER, new Object[]{this.getDisplayName().getString(), MoriFlyAbility.INSTANCE.getUnlocalizedName()});
            return ((MorphInfo)CartMorphs.MORI_FLY.get()).isActive(entity) ? AbilityUseResult.fail((ITextComponent)this.text) : AbilityUseResult.success();
        });
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.hitTriggerComponent, this.continuousComponent, this.statsComponent, this.morphComponent});
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)PUNCH_DAMAGE_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED_MODIFIER);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 600.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.MORI_ARM.get());
        this.statsComponent.applyModifiers(entity);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.stopMorph(entity);
        this.statsComponent.removeModifiers(entity);
        this.cooldownComponent.getBonusManager().removeBonus(MoriHelper.FOREST_COOLDOWN_BONUS);
        if (MoriHelper.isFruitBoosted(entity)) {
            this.cooldownComponent.getBonusManager().addBonus(MoriHelper.FOREST_COOLDOWN_BONUS, "Forest and Jungle Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        float cooldown = MathHelper.func_76131_a((float)this.continuousComponent.getContinueTime(), (float)100.0f, (float)600.0f);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private boolean hitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        double ran;
        if (this.continuousComponent.isContinuous() && (ran = Math.random() * 100.0) < 9.0) {
            target.func_195064_c(new EffectInstance((Effect)CartEffects.OVERGROWN.get(), 50, 0));
        }
        return true;
    }
}

