/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mori;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.mori.MoriFlyAbility;
import net.MrMagicalCart.cartaddon.abilities.mori.PiercingBlowsAbility;
import net.MrMagicalCart.cartaddon.abilities.mori.RootEmergenceAbility;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class KinnikuMoriMoriAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"kinniku_mori_mori", (Pair[])new Pair[]{ImmutablePair.of((Object)"Transforms the user into a giant wood golem that can rival giants. (Can't activate alongside Mori Arm or Mori Flight)", null)});
    public static final AbilityCore<KinnikuMoriMoriAbility> INSTANCE = new AbilityCore.Builder("Kinniku Mori Mori", AbilityCategory.DEVIL_FRUITS, KinnikuMoriMoriAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)100.0f), ChangeStatsComponent.getTooltip()}).build();
    private static final AbilityAttributeModifier SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_MOVEMENT_SPEED_UUID, INSTANCE, "Kinniku Mori Mori Speed Modifier", -0.55, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AbilityAttributeModifier ARMOR_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_UUID, INSTANCE, "Kinniku Mori Mori Armor Modifier", 18.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STRENGTH_UUID, INSTANCE, "Kinniku Mori Mori Strength Modifier", 12.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ATTACK_SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_SPEED_UUID, INSTANCE, "Kinniku Mori Mori Attack Speed Modifier", -0.2, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier JUMP_BOOST_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_JUMP_BOOST_UUID, INSTANCE, "Kinniku Mori Mori Jump Modifier", -1.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier REACH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_REACH_UUID, INSTANCE, "Kinniku Mori Mori Reach Modifier", 14.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ARMOR_TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_TOUGHNESS_UUID, INSTANCE, "Kinniku Mori Mori Armor Toughness Modifier", 4.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_TOUGHNESS_UUID, INSTANCE, "Kinniku Mori Mori Toughness Modifier", 4.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier FALL_RESISTANCE_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_FALL_RESISTANCE_UUID, INSTANCE, "Kinniku Mori Mori Fall Resistance Modifier", 28.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AbilityAttributeModifier STEP_ASSIST_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STEP_HEIGHT_UUID, INSTANCE, "Kinniku Mori Mori Step Assist Modifier", 5.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier MAX_HEALTH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STEP_HEIGHT_UUID, INSTANCE, "Kinniku Mori Mori Max Health Modifier", 50.0, AttributeModifier.Operation.ADDITION);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private final float MIN_COOLDOWN = 200.0f;

    public KinnikuMoriMoriAbility(AbilityCore<KinnikuMoriMoriAbility> core) {
        super(core);
        this.addCanUseCheck((entity, ability) -> {
            TranslationTextComponent text = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_TOGETHER, new Object[]{this.getDisplayName().getString(), MoriFlyAbility.INSTANCE.getUnlocalizedName()});
            return ((MorphInfo)CartMorphs.MORI_FLY.get()).isActive(entity) ? AbilityUseResult.fail((ITextComponent)text) : AbilityUseResult.success();
        });
        Predicate<LivingEntity> isActive = entity -> this.morphComponent.isMorphed();
        this.addComponents(new AbilityComponent[]{this.damageTakenComponent});
        this.statsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)SPEED_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.JUMP_HEIGHT, (AttributeModifier)JUMP_BOOST_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier((Supplier)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)ARMOR_TOUGHNESS_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.FALL_RESISTANCE, (AttributeModifier)FALL_RESISTANCE_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_ASSIST_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier(Attributes.field_233818_a_, (AttributeModifier)MAX_HEALTH_MODIFIER, isActive);
        this.continuousComponent.addStartEvent(this::startContinuityEvent).addEndEvent(this::stopContinuityEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.startMorph(entity, this.getTransformation());
        this.statsComponent.applyModifiers(entity);
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        PiercingBlowsAbility piercingBlowsAbility = (PiercingBlowsAbility)props.getEquippedAbility(PiercingBlowsAbility.INSTANCE);
        RootEmergenceAbility rootEmergenceAbility = (RootEmergenceAbility)props.getEquippedAbility(RootEmergenceAbility.INSTANCE);
        if (piercingBlowsAbility != null) {
            piercingBlowsAbility.switchKinniku(entity);
        }
        if (rootEmergenceAbility != null) {
            rootEmergenceAbility.switchKinniku(entity);
        }
    }

    private void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.stopMorph(entity);
        this.statsComponent.removeModifiers(entity);
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        PiercingBlowsAbility piercingBlowsAbility = (PiercingBlowsAbility)props.getEquippedAbility(PiercingBlowsAbility.INSTANCE);
        RootEmergenceAbility rootEmergenceAbility = (RootEmergenceAbility)props.getEquippedAbility(RootEmergenceAbility.INSTANCE);
        if (piercingBlowsAbility != null) {
            piercingBlowsAbility.switchNormal(entity);
        }
        if (rootEmergenceAbility != null) {
            rootEmergenceAbility.switchNormal(entity);
        }
        this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
    }

    public MorphInfo getTransformation() {
        return (MorphInfo)CartMorphs.KINNIKU_MORI_MORI.get();
    }

    public float getCooldownTicks() {
        return 100.0f;
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (AbilityHelper.isDodging((LivingEntity)entity)) {
            return damage;
        }
        if (this.continuousComponent.isContinuous()) {
            if (damageSource == DamageSource.field_76379_h) {
                return 0.0f;
            }
            return damage * 0.65f;
        }
        return damage;
    }
}

