/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mori;

import java.util.Random;
import net.MrMagicalCart.cartaddon.abilities.mori.MoriHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;

public class GrassWalkerAbility
extends PassiveAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"grass_walker", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user grows grass around themselves passively. (Turns dirt and stone type blocks to grass)", null), ImmutablePair.of((Object)"\u00a7aCrouching\u00a7r temporarily disables the ability", null)});
    public static final AbilityCore<GrassWalkerAbility> INSTANCE;
    private static final BlockProtectionRule GRIEF_RULE;
    public static Block[] bannedBlocks;

    public GrassWalkerAbility(AbilityCore<GrassWalkerAbility> ability) {
        super(ability);
        this.addDuringPassiveEvent(this::duringPassiveEvent);
    }

    private void duringPassiveEvent(LivingEntity player) {
        if (!(player.field_70170_p.field_72995_K || player.func_213453_ef() || AbilityHelper.isWeakenedByKairosekiOrWater((LivingEntity)player) || player.func_184187_bx() != null || player.func_110143_aJ() < player.func_110138_aP() / 5.0f)) {
            BlockPos.Mutable mutpos = new BlockPos.Mutable();
            BlockPos.Mutable above = new BlockPos.Mutable();
            int rangeH = 3;
            int rangeV = 2;
            if (MoriHelper.usingKinniku(player)) {
                rangeH = 20;
                rangeV = 12;
            }
            for (int x = -rangeH; x <= rangeH; ++x) {
                for (int y = -rangeV; y <= rangeV; ++y) {
                    for (int z = -rangeH; z <= rangeH; ++z) {
                        BlockState aboveBlockState;
                        mutpos.func_189532_c(player.func_226277_ct_() + (double)x, player.func_226278_cu_() + (double)y, player.func_226281_cx_() + (double)z);
                        above.func_189532_c(player.func_226277_ct_() + (double)x, player.func_226278_cu_() + (double)y + 1.0, player.func_226281_cx_() + (double)z);
                        BlockState blockState = player.field_70170_p.func_180495_p((BlockPos)mutpos);
                        Block placedBlock = Blocks.field_196658_i;
                        if ((blockState.func_185904_a() == Material.field_151576_e || blockState.func_185904_a() == Material.field_151578_c && blockState.func_177230_c() != Blocks.field_150458_ak) && AbilityHelper.placeBlockIfAllowed((LivingEntity)player, (BlockPos)mutpos, (BlockState)(placedBlock = (aboveBlockState = player.field_70170_p.func_180495_p((BlockPos)above)).func_177230_c() == Blocks.field_150350_a || aboveBlockState.func_177230_c() instanceof FlowerBlock || aboveBlockState.func_177230_c() instanceof SaplingBlock || aboveBlockState.func_177230_c() == Blocks.field_150349_c || aboveBlockState.func_177230_c() == Blocks.field_196804_gh || aboveBlockState.func_177230_c() == Blocks.field_196554_aH || aboveBlockState.func_177230_c() == Blocks.field_196805_gi || aboveBlockState.func_177230_c() instanceof FenceBlock || aboveBlockState.func_177230_c() instanceof WallBlock ? Blocks.field_196658_i : (blockState.func_177230_c() == Blocks.field_150347_e ? Blocks.field_150341_Y : (blockState.func_177230_c() == Blocks.field_196696_di ? Blocks.field_196698_dj : Blocks.field_150346_d))).func_176223_P(), (int)3, (BlockProtectionRule)GRIEF_RULE)) {
                            player.field_70170_p.func_205220_G_().func_205360_a((BlockPos)mutpos, (Object)placedBlock, MathHelper.func_76136_a((Random)player.func_70681_au(), (int)20, (int)60));
                        }
                        if (blockState.func_177230_c() != Blocks.field_150346_d) continue;
                        blockState.func_227034_b_((ServerWorld)player.field_70170_p, (BlockPos)mutpos, new Random());
                    }
                }
            }
        }
    }

    static {
        bannedBlocks = new Block[]{Blocks.field_222411_kZ, Blocks.field_222450_ln, Blocks.field_150341_Y, Blocks.field_196723_eg, Blocks.field_222462_lz, Blocks.field_222448_ll, Blocks.field_222409_kX, Blocks.field_196698_dj, Blocks.field_196702_dl, Blocks.field_196700_dk};
        INSTANCE = new AbilityCore.Builder("Grass Walker", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, GrassWalkerAbility::new).addDescriptionLine(DESCRIPTION).build();
        GRIEF_RULE = new BlockProtectionRule.Builder(new BlockProtectionRule[]{DefaultProtectionRules.CORE_FOLIAGE_ORE}).addBannedBlocks(bannedBlocks).build();
    }
}

