/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mori;

import java.util.Random;
import net.MrMagicalCart.cartaddon.abilities.mori.MoriHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;

public class FlowerWalkerAbility
extends PassiveAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"flower_walker", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user grows grass, flowers, and saplings on grass blocks.", null), ImmutablePair.of((Object)"\u00a7aCrouching\u00a7r temporarily disables the ability", null)});
    public static final AbilityCore<FlowerWalkerAbility> INSTANCE = new AbilityCore.Builder("Flower Walker", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, FlowerWalkerAbility::new).addDescriptionLine(DESCRIPTION).build();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(new BlockProtectionRule[]{AirBlockProtectionRule.INSTANCE}).build();
    private final Block[] flowers = new Block[]{Blocks.field_196606_bd, Blocks.field_196605_bc, Blocks.field_196607_be, Blocks.field_222387_by, Blocks.field_196614_bj, Blocks.field_196613_bi, Blocks.field_196612_bh, Blocks.field_196615_bk, Blocks.field_196610_bg, Blocks.field_196616_bl, Blocks.field_196609_bf, Blocks.field_222383_bA};
    private final Block[] grass = new Block[]{Blocks.field_150349_c, Blocks.field_196554_aH};
    private final Block[] saplings = new Block[]{Blocks.field_196674_t, Blocks.field_196676_v, Blocks.field_196675_u};

    public FlowerWalkerAbility(AbilityCore<FlowerWalkerAbility> ability) {
        super(ability);
        this.addDuringPassiveEvent(this::duringPassiveEvent);
    }

    private void duringPassiveEvent(LivingEntity player) {
        if (!(player.field_70170_p.field_72995_K || player.func_213453_ef() || AbilityHelper.isWeakenedByKairosekiOrWater((LivingEntity)player) || player.func_184187_bx() != null || player.func_110143_aJ() < player.func_110138_aP() / 5.0f)) {
            int rangeH = 3;
            int rangeV = 2;
            if (MoriHelper.usingKinniku(player)) {
                rangeH = 14;
                rangeV = 7;
            }
            BlockPos.Mutable mutpos = new BlockPos.Mutable();
            BlockPos.Mutable above = new BlockPos.Mutable();
            BlockPos.Mutable aboveAgain = new BlockPos.Mutable();
            for (int x = -rangeH; x <= rangeH; ++x) {
                for (int y = -rangeV; y <= rangeV; ++y) {
                    for (int z = -rangeH; z <= rangeH; ++z) {
                        mutpos.func_189532_c(player.func_226277_ct_() + (double)x, player.func_226278_cu_() + (double)y, player.func_226281_cx_() + (double)z);
                        above.func_189532_c(player.func_226277_ct_() + (double)x, player.func_226278_cu_() + (double)y + 1.0, player.func_226281_cx_() + (double)z);
                        aboveAgain.func_189532_c(player.func_226277_ct_() + (double)x, player.func_226278_cu_() + (double)y + 2.0, player.func_226281_cx_() + (double)z);
                        BlockState blockState = player.field_70170_p.func_180495_p((BlockPos)mutpos);
                        Block placedBlock = Blocks.field_196605_bc;
                        double random = player.func_70681_au().nextDouble() * 100.0;
                        if (random < 60.0) {
                            placedBlock = random < 57.0 ? Blocks.field_150349_c : Blocks.field_196554_aH;
                        } else if (!(random < 75.0)) {
                            double ran;
                            placedBlock = random < 95.0 ? (random < 77.0 ? Blocks.field_196606_bd : (random < 79.0 ? Blocks.field_196605_bc : (random < 81.0 ? Blocks.field_222387_by : (random < 83.0 ? Blocks.field_196609_bf : (random < 85.0 ? Blocks.field_196614_bj : (random < 87.0 ? Blocks.field_196613_bi : (random < 89.0 ? Blocks.field_196615_bk : (random < 91.0 ? Blocks.field_222383_bA : (random < 93.0 ? Blocks.field_196607_be : (random < 95.0 ? Blocks.field_196610_bg : (random < 97.0 ? Blocks.field_196616_bl : Blocks.field_196612_bh))))))))))) : ((ran = Math.random() * 90.0) < 30.0 ? Blocks.field_196676_v : (ran < 60.0 ? Blocks.field_196675_u : Blocks.field_196674_t));
                        }
                        if (blockState.func_177230_c() == Blocks.field_196658_i) {
                            BlockState aboveBlockState = player.field_70170_p.func_180495_p((BlockPos)above);
                            BlockState aboveAboveBlockState = player.field_70170_p.func_180495_p((BlockPos)aboveAgain);
                            if (aboveBlockState.func_177230_c() == Blocks.field_150350_a && aboveAboveBlockState.func_177230_c() == Blocks.field_150350_a && AbilityHelper.placeBlockIfAllowed((LivingEntity)player, (BlockPos)above, (BlockState)placedBlock.func_176223_P(), (int)3, (BlockProtectionRule)GRIEF_RULE)) {
                                player.field_70170_p.func_205220_G_().func_205360_a((BlockPos)above, (Object)placedBlock, MathHelper.func_76136_a((Random)player.func_70681_au(), (int)20, (int)60));
                            }
                        }
                        if (blockState.func_177230_c() != Blocks.field_150346_d) continue;
                        blockState.func_227034_b_((ServerWorld)player.field_70170_p, (BlockPos)mutpos, new Random());
                    }
                }
            }
        }
    }
}

