/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mori;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.MrMagicalCart.cartaddon.abilities.mori.MoriHelper;
import net.MrMagicalCart.cartaddon.init.CartBlocks;
import net.MrMagicalCart.cartaddon.init.CartEffects;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.BlockPlacingHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class FlowerFieldNewAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"flower_field", (Pair[])new Pair[]{ImmutablePair.of((Object)"Freezes a small area around the user and everyone inside of it.", null)});
    private static final int CHARGE_TIME = 100;
    private static final int MIN_COOLDOWN = 600;
    private static final int MAX_COOLDOWN = 900;
    private static final int ICE_RANGE = 12;
    private static final float ENTITY_FREEZE_RANGE = 1.0f;
    public static final AbilityCore<FlowerFieldNewAbility> INSTANCE = new AbilityCore.Builder("Flower Field", AbilityCategory.DEVIL_FRUITS, FlowerFieldNewAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)600.0f, (float)900.0f), ChargeComponent.getTooltip((float)100.0f), RangeComponent.getTooltip((float)32.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).build();
    private static final BlockProtectionRule PROTECTION_RULE = new BlockProtectionRule.Builder(new BlockProtectionRule[]{DefaultProtectionRules.CORE_FOLIAGE_ORE_LIQUID}).addReplaceRules((world, pos, state) -> {
        if (state.func_177230_c().equals(Blocks.field_150433_aE) && (Integer)state.func_177229_b((Property)SnowBlock.field_176315_a) > 5) {
            world.func_180501_a(pos, ((Block)CartBlocks.MORI_BLOCK.get()).func_176223_P(), 3);
            return true;
        }
        return false;
    }).build();
    private final BlockPlacingHelper blockPlacingHelper = new BlockPlacingHelper();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, comp -> (double)comp.getChargePercentage() > 0.5).addStartEvent(100, this::startChargeEvent).addTickEvent(100, this::duringChargeEvent).addEndEvent(100, this::stopChargeEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);

    public FlowerFieldNewAbility(AbilityCore<FlowerFieldNewAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.rangeComponent, this.hitTrackerComponent});
        this.addCanUseCheck(AbilityHelper::requiresOnGround);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            this.chargeComponent.startCharging(entity, 100.0f);
        }
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.hitTrackerComponent.clearHits();
            this.blockPlacingHelper.clearList();
            double radiusXZ = 32.0;
            double radiusY = 3.0;
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), SoundEvents.field_206940_M, SoundCategory.PLAYERS, 10.0f, 1.0f);
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.FLOWER_FIELD.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
            BlockPos.Mutable mutpos = new BlockPos.Mutable();
            for (double y = -radiusY; y < radiusY; y += 1.0) {
                for (double x = -radiusXZ; x < radiusXZ; x += 1.0) {
                    for (double z = -radiusXZ; z < radiusXZ; z += 1.0) {
                        double posZ;
                        double posY;
                        double posX = entity.func_226277_ct_() + x + (!(x < -WyHelper.randomWithRange((int)((int)(radiusXZ * 0.5)), (int)((int)(radiusXZ * 0.75)))) && !(x > WyHelper.randomWithRange((int)((int)(radiusXZ * 0.5)), (int)((int)(radiusXZ * 0.75)))) ? 0.0 : WyHelper.randomWithRange((int)-5, (int)5));
                        if (!AbilityHelper.canPlaceBlock((World)entity.field_70170_p, (double)posX, (double)(posY = entity.func_226278_cu_() + y), (double)(posZ = entity.func_226281_cx_() + z + (!(z < -WyHelper.randomWithRange((int)((int)(radiusXZ * 0.5)), (int)((int)(radiusXZ * 0.75)))) && !(z > WyHelper.randomWithRange((int)((int)(radiusXZ * 0.5)), (int)((int)(radiusXZ * 0.75)))) ? 0.0 : WyHelper.randomWithRange((int)-5, (int)5))), (BlockState)((Block)CartBlocks.MORI_BLOCK.get()).func_176223_P(), (int)3, (BlockProtectionRule)PROTECTION_RULE)) continue;
                        mutpos.func_189532_c(posX, posY, posZ);
                        this.blockPlacingHelper.addBlockPos((BlockPos)mutpos, (int)(x * x + y * y + z * z));
                    }
                }
            }
        }
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1, false, false));
        Set blockList = this.blockPlacingHelper.getBlockList();
        int finished = blockList.size() / 100;
        Iterator iterator = blockList.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos = (BlockPos)iterator.next();
            if (finished-- < 0) break;
            AbilityHelper.placeBlockIfAllowed((LivingEntity)entity, (BlockPos)blockPos, (BlockState)((Block)CartBlocks.MORI_BLOCK.get()).func_176223_P(), (int)3, (BlockProtectionRule)PROTECTION_RULE);
            List targets = this.rangeComponent.getTargetsInArea(entity, blockPos, 1.0f);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
                EffectInstance instance = new EffectInstance((Effect)CartEffects.OVERGROWN.get(), 100, 0);
                target.func_195064_c(instance);
            }
            iterator.remove();
        }
    }

    private void stopChargeEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.getBonusManager().removeBonus(MoriHelper.FOREST_COOLDOWN_BONUS);
        if (MoriHelper.isFruitBoosted(entity)) {
            this.cooldownComponent.getBonusManager().addBonus(MoriHelper.FOREST_COOLDOWN_BONUS, "Forest and Jungle Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 400.0f + this.chargeComponent.getChargeTime());
    }
}

