/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mori;

import java.util.UUID;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.mori.MoriHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class BokarinAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"bokarin", (Pair[])new Pair[]{ImmutablePair.of((Object)"Enforces the user's body to be more defensive, and resistant to fire.", null), ImmutablePair.of((Object)"While in a forest or jungle the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final int HOLD_TIME = 900;
    private static final int MIN_COOLDOWN = 150;
    private static final int MAX_COOLDOWN = 400;
    public static final AbilityCore<BokarinAbility> INSTANCE = new AbilityCore.Builder("Bokarin", AbilityCategory.DEVIL_FRUITS, BokarinAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip((float)900.0f), CooldownComponent.getTooltip((float)150.0f, (float)1050.0f), ChangeStatsComponent.getTooltip()}).build();
    private static final AbilityAttributeModifier ARMOR_MODIFIER = new AbilityAttributeModifier(UUID.fromString("547a5eaa-a969-4328-9364-a40638876d54"), INSTANCE, "Bokarin Armor Modifier", 8.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ARMOR_TOUGHNESS_MODIFIER = new AbilityAttributeModifier(UUID.fromString("764f6317-2d9f-4c54-8906-0201f1521212"), INSTANCE, "Bokarin Armor Toughness Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER = new AbilityAttributeModifier(UUID.fromString("7db0de61-b5a2-40d9-ab0e-42d6afb5bece"), INSTANCE, "Bokarin Toughness Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent((IAbility)this);

    public BokarinAbility(AbilityCore<BokarinAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.changeStatsComponent});
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)ARMOR_TOUGHNESS_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 900.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.applyModifiers(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.removeModifiers(entity);
        this.cooldownComponent.getBonusManager().removeBonus(MoriHelper.FOREST_COOLDOWN_BONUS);
        if (MoriHelper.isFruitBoosted(entity)) {
            this.cooldownComponent.getBonusManager().addBonus(MoriHelper.FOREST_COOLDOWN_BONUS, "Forest and Jungle Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        float cooldown = 150.0f + this.continuousComponent.getContinueTime();
        this.cooldownComponent.startCooldown(entity, cooldown);
    }
}

