/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mokuextra;

import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.entities.mobs.marines.SmokerEntity;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.particles.effects.mokuextra.WorldOfSmokeParticleEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class WorldOfSmokeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"world_of_smoke", (Pair[])new Pair[]{ImmutablePair.of((Object)"Creates a zone of smoke that reduces incoming damage by 50% and confuses all those nearby. (Stuns entities)", null)});
    private static final int ON_HOLD = 100;
    private static final int MIN_COOLDOWN = 200;
    private static final int MAX_COOLDOWN = 250;
    private static final double RANGE = 20.0;
    private static final float DAMAGE = 3.0f;
    public static final AbilityCore<WorldOfSmokeAbility> INSTANCE = new AbilityCore.Builder("World of Smoke", AbilityCategory.DEVIL_FRUITS, WorldOfSmokeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)200.0f, (float)250.0f), ContinuousComponent.getTooltip((float)100.0f), DealDamageComponent.getTooltip((float)3.0f), RangeComponent.getTooltip((float)20.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE), ChangeStatsComponent.getTooltip()}).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.SMOKE).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final Interval particleInterval = new Interval(2);
    private final Interval clearHitsInterval = new Interval(20);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::damageTakenEvent, DamageTakenComponent.DamageState.HURT);

    public WorldOfSmokeAbility(AbilityCore<WorldOfSmokeAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.damageTakenComponent, this.dealDamageComponent, this.continuousComponent, this.hitTrackerComponent, this.dealDamageComponent});
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 100.0f);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.particleInterval.restartIntervalToZero();
        ((ModDamageSource)this.dealDamageComponent.getDamageSource(entity)).setUnavoidable();
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.VANISH.get(), 5, 0, false, false));
        if (super.canUse(entity).isFail()) {
            this.continuousComponent.stopContinuity(entity);
        }
        if (this.particleInterval.canTick()) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.WORLD_OF_SMOKE.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (ParticleEffect.Details)new WorldOfSmokeParticleEffect.Details(5.0f, 4.0f, 4.0f));
        }
        List targets = WyHelper.getNearbyLiving((Vector3d)entity.func_213303_ch(), (IWorld)entity.field_70170_p, (double)20.0, (double)10.0, (double)20.0, (Predicate)ModEntityPredicates.getEnemyFactions((LivingEntity)entity));
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 3.0f)) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.SMOKE.get(), 200, 0));
            target.func_195064_c(new EffectInstance(Effects.field_76431_k, 100, 1));
            if (entity instanceof SmokerEntity) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 100, 0));
            }
            if (target instanceof PlayerEntity) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 15, 0, false, false));
        }
        if (this.clearHitsInterval.canTick()) {
            this.hitTrackerComponent.clearHits();
        }
        AbilityHelper.slowEntityFall((LivingEntity)entity);
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1, false, false));
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        float cooldown = 200.0f + this.continuousComponent.getContinueTime() / 2.0f;
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private float damageTakenEvent(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (AbilityHelper.isDodging((LivingEntity)entity)) {
            return damage;
        }
        if (this.continuousComponent.isContinuous()) {
            return damage * 0.5f;
        }
        return damage;
    }
}

