/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mokuextra;

import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.entities.projectiles.mokuextra.SmokeBlastProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class SmokeBlastAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"smoke_blast", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user launches a cloud of smoke that disorients their target.", null)});
    private static final int COOLDOWN = 300;
    public static final AbilityCore<SmokeBlastAbility> INSTANCE = new AbilityCore.Builder("Smoke Blast", AbilityCategory.DEVIL_FRUITS, SmokeBlastAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)300.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.SMOKE).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);

    public SmokeBlastAbility(AbilityCore<? extends PunchAbility2> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.projectileComponent});
        this.continuousComponent.addTickEvent(100, this::tickContinuityEvent);
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && entity.field_82175_bq) {
            this.projectileComponent.shoot(entity, 2.0f, 0.0f);
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.MERA_SFX.get(), SoundCategory.PLAYERS, 3.0f, 0.25f);
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private SmokeBlastProjectile createProjectile(LivingEntity entity) {
        SmokeBlastProjectile proj = new SmokeBlastProjectile(entity.field_70170_p, entity, (Ability)this);
        return proj;
    }

    public float getPunchCooldown() {
        return 300.0f;
    }

    public boolean onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        this.projectileComponent.shoot(entity, 2.0f, 0.0f);
        return true;
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    public boolean isParallel() {
        return true;
    }

    public int getUseLimit() {
        return 1;
    }
}

