/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mokuextra;

import net.MrMagicalCart.cartaddon.entities.mobs.marines.SmokerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.moku.WhiteSnakeProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class ReworkedWhiteSnakeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"white_snake", (Pair[])new Pair[]{ImmutablePair.of((Object)"Launches a long dense cloud of smoke in the shape of a snake that will damage and give poison to its target", null)});
    private static final int COOLDOWN = 240;
    public static final AbilityCore<ReworkedWhiteSnakeAbility> INSTANCE = new AbilityCore.Builder("White Snake", AbilityCategory.DEVIL_FRUITS, ReworkedWhiteSnakeAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)240.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceElement(SourceElement.SMOKE).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);

    public ReworkedWhiteSnakeAbility(AbilityCore<ReworkedWhiteSnakeAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.projectileComponent, this.animationComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.AIM_SNIPER, 7);
        this.projectileComponent.shoot(entity, 3.0f, 1.0f);
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private WhiteSnakeProjectile createProjectile(LivingEntity entity) {
        WhiteSnakeProjectile proj = new WhiteSnakeProjectile(entity.field_70170_p, entity, (Ability)this);
        proj.setDamage(35.0f);
        if (entity instanceof SmokerEntity) {
            proj.setDamage(45.0f);
        }
        return proj;
    }
}

