/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.mokuextra;

import net.MrMagicalCart.cartaddon.entities.mobs.marines.SmokerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.RepeaterAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.moku.WhiteBlowProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class ReworkedWhiteBlowRushAbility
extends RepeaterAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"white_blow_rush", (Pair[])new Pair[]{ImmutablePair.of((Object)"Shoots clouds of smoke to engulf the opponent and trap them", null)});
    private static final float COOLDOWN = 260.0f;
    public static final AbilityCore<ReworkedWhiteBlowRushAbility> INSTANCE = new AbilityCore.Builder("White Blow Rush", AbilityCategory.DEVIL_FRUITS, ReworkedWhiteBlowRushAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)260.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.SMOKE).build();
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private float cooldown;
    private int triggers;
    private int interval;

    public ReworkedWhiteBlowRushAbility(AbilityCore<ReworkedWhiteBlowRushAbility> core) {
        super(core);
        this.isNew = true;
        this.cooldown = 260.0f;
        this.triggers = 11;
        this.interval = 5;
        this.setCustomShootLogic(living -> {
            for (int i = 0; i < 5; ++i) {
                this.projectileComponent.shootWithSpread(living, 2.75f, 0.5f, 3);
            }
        });
        super.addComponents(new AbilityComponent[]{this.animationComponent});
        this.continuousComponent.addStartEvent(this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(this::endContinuityEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.PUNCH_RUSH);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.repeaterComponent.stop(entity);
    }

    public int getMaxTriggers() {
        return this.triggers;
    }

    public int getTriggerInterval() {
        return this.interval;
    }

    public float getRepeaterCooldown() {
        return this.cooldown;
    }

    public AbilityProjectileEntity getProjectileFactory(LivingEntity entity) {
        WhiteBlowProjectile projectile = new WhiteBlowProjectile(entity.field_70170_p, entity, (Ability)this);
        projectile.setDamage(7.0f);
        if (entity instanceof SmokerEntity) {
            projectile.setDamage(15.0f);
        }
        return projectile;
    }
}

